/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.decomposition;

import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapitools.decomposition.LocalityChecker;
import org.semanticweb.owlapitools.decomposition.SigAccessor;

public class BotEquivalenceEvaluator
extends SigAccessor
implements OWLObjectVisitor {
    boolean isBotEq = false;

    public BotEquivalenceEvaluator(LocalityChecker l) {
        super(l);
    }

    private boolean isBotDistinct(OWLObject c) {
        if (this.localityChecker.isTopEquivalent(c)) {
            return true;
        }
        return c instanceof OWLDatatype;
    }

    private boolean isCardLargerThan(OWLObject c, int n) {
        if (n == 0) {
            return this.isBotDistinct(c);
        }
        if (c instanceof OWLDatatype) {
            return ((OWLDatatype)c).isBuiltIn() && !((OWLDatatype)c).getBuiltInDatatype().isFinite();
        }
        return false;
    }

    private boolean isMaxBotEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return this.isBotEquivalent(r) && this.isCardLargerThan(c, n);
    }

    private boolean isMinBotEquivalent(int n, OWLPropertyExpression r, OWLPropertyRange c) {
        return n > 0 && (this.isBotEquivalent(r) || this.isBotEquivalent(c));
    }

    boolean isBotEquivalent(OWLObject expr) {
        if (expr.isBottomEntity()) {
            return true;
        }
        if (expr.isTopEntity()) {
            return false;
        }
        expr.accept(this);
        return this.isBotEq;
    }

    @Override
    public void visit(OWLClass expr) {
        this.isBotEq = !this.getSignature().topCLocal() && !this.getSignature().contains(expr);
    }

    @Override
    public void visit(OWLObjectComplementOf expr) {
        this.isBotEq = this.localityChecker.isTopEquivalent(expr.getOperand());
    }

    @Override
    public void visit(OWLObjectIntersectionOf expr) {
        this.isBotEq = expr.operands().anyMatch(this::isBotEquivalent);
    }

    @Override
    public void visit(OWLObjectUnionOf expr) {
        this.isBotEq = !expr.operands().anyMatch(p -> !this.isBotEquivalent((OWLObject)p));
    }

    @Override
    public void visit(OWLObjectOneOf expr) {
        this.isBotEq = expr.individuals().count() == 0L;
    }

    @Override
    public void visit(OWLObjectHasSelf expr) {
        this.isBotEq = this.isBotEquivalent(expr.getProperty());
    }

    @Override
    public void visit(OWLObjectHasValue expr) {
        this.isBotEq = this.isBotEquivalent(expr.getProperty());
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom expr) {
        this.isBotEq = this.isMinBotEquivalent(1, expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectAllValuesFrom expr) {
        this.isBotEq = this.localityChecker.isTopEquivalent(expr.getProperty()) && this.isBotEquivalent((OWLObject)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectMinCardinality expr) {
        this.isBotEq = this.isMinBotEquivalent(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectMaxCardinality expr) {
        this.isBotEq = this.isMaxBotEquivalent(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectExactCardinality expr) {
        int n = expr.getCardinality();
        this.isBotEq = this.isMinBotEquivalent(n, expr.getProperty(), (OWLPropertyRange)expr.getFiller()) || this.isMaxBotEquivalent(n, expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataHasValue expr) {
        this.isBotEq = this.isBotEquivalent(expr.getProperty());
    }

    @Override
    public void visit(OWLDataSomeValuesFrom expr) {
        this.isBotEq = this.isMinBotEquivalent(1, expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataAllValuesFrom expr) {
        this.isBotEq = this.localityChecker.isTopEquivalent(expr.getProperty()) && !this.localityChecker.isTopEquivalent((OWLObject)expr.getFiller());
    }

    @Override
    public void visit(OWLDataMinCardinality expr) {
        this.isBotEq = this.isMinBotEquivalent(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataMaxCardinality expr) {
        this.isBotEq = this.isMaxBotEquivalent(expr.getCardinality(), expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLDataExactCardinality expr) {
        int n = expr.getCardinality();
        this.isBotEq = this.isMinBotEquivalent(n, expr.getProperty(), (OWLPropertyRange)expr.getFiller()) || this.isMaxBotEquivalent(n, expr.getProperty(), (OWLPropertyRange)expr.getFiller());
    }

    @Override
    public void visit(OWLObjectProperty expr) {
        this.isBotEq = !this.getSignature().topRLocal() && !this.getSignature().contains(expr);
    }

    @Override
    public void visit(OWLObjectInverseOf expr) {
        this.isBotEq = this.isBotEquivalent(expr.getInverse());
    }

    @Override
    public void visit(OWLDataProperty expr) {
        this.isBotEq = !this.getSignature().topRLocal() && !this.getSignature().contains(expr);
    }

    @Override
    public void visit(OWLDatatype node) {
        this.isBotEq = node.isBottomEntity();
    }

    @Override
    public void visit(OWLLiteral node) {
        this.isBotEq = false;
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.isBotEq = this.localityChecker.isTopEquivalent(node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.isBotEq = node.values().count() == 0L;
    }
}

