/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.CoordinateOperationException;
import org.cts.op.TooManyIterationsException;

public class IterativeTransformation
extends AbstractCoordinateOperation
implements CoordinateOperation {
    CoordinateOperation op;
    int[] realValueIndex;
    int[] calculatedValueIndex;
    double[] tolerance;
    int maxIterations = 12;

    public IterativeTransformation(CoordinateOperation op, int[] realValueIndex, int[] calculatedValueIndex, double[] tol, int maxIterations) throws Exception {
        super(new Identifier(IterativeTransformation.class));
        this.op = op;
        if (calculatedValueIndex.length != realValueIndex.length) {
            throw new Exception("The two arrays in argument must have the same length.");
        }
        this.calculatedValueIndex = calculatedValueIndex;
        this.realValueIndex = realValueIndex;
        this.tolerance = tol;
        this.maxIterations = maxIterations;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException, CoordinateOperationException {
        int i;
        boolean iter = false;
        int count = 0;
        for (i = 0; i < this.realValueIndex.length; ++i) {
            iter = iter || Math.abs(coord[this.realValueIndex[i]] - coord[this.calculatedValueIndex[i]]) > this.tolerance[i];
        }
        while (iter) {
            coord = this.op.transform(coord);
            iter = false;
            for (i = 0; i < this.realValueIndex.length; ++i) {
                iter = iter || Math.abs(coord[this.realValueIndex[i]] - coord[this.calculatedValueIndex[i]]) > this.tolerance[i];
            }
            if (++count <= this.maxIterations) continue;
            throw new TooManyIterationsException(this, count);
        }
        return coord;
    }

    public double getPrecision() {
        return this.op.getPrecision() / 2.0;
    }

    public String toString() {
        return "Iterative transformation based on [\n" + this.op.toString().replaceAll("\n", "\n\t") + "\n]";
    }
}

