/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op;

import org.cts.CoordinateDimensionException;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.CoordinateOperation;
import org.cts.op.NonInvertibleOperationException;

public class OppositeCoordinate
extends AbstractCoordinateOperation {
    private int index;

    public OppositeCoordinate(int index) {
        super(new Identifier(CoordinateOperation.class, "Transform the coordinate " + index + " into its opposite."));
        this.index = index;
        this.precision = 0.0;
    }

    public double[] transform(double[] coord) throws IllegalCoordinateException {
        if (this.index >= coord.length) {
            throw new CoordinateDimensionException(coord, this.index);
        }
        coord[this.index] = -coord[this.index];
        return coord;
    }

    public CoordinateOperation inverse() throws NonInvertibleOperationException {
        return this;
    }
}

