/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.cts.Identifier;
import org.cts.Parameter;
import org.cts.datum.Ellipsoid;
import org.cts.op.AbstractCoordinateOperation;
import org.cts.op.NonInvertibleOperationException;
import org.cts.parser.prj.PrjWriter;
import org.cts.units.Measure;
import org.cts.units.Unit;
import org.cts.util.AngleFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Projection
extends AbstractCoordinateOperation {
    public static final Parameter[] DEFAULT_PARAMETERS = new Parameter[]{new Parameter("false easting", new Measure(0.0, Unit.METER)), new Parameter("false northing", new Measure(0.0, Unit.METER)), new Parameter("central meridian", new Measure(0.0, Unit.DEGREE)), new Parameter("standard parallel 1", new Measure(0.0, Unit.DEGREE)), new Parameter("standard parallel 2", new Measure(0.0, Unit.DEGREE)), new Parameter("latitude of true scale", new Measure(0.0, Unit.DEGREE)), new Parameter("azimuth", new Measure(0.0, Unit.DEGREE)), new Parameter("rectified grid angle", new Measure(0.0, Unit.DEGREE)), new Parameter("scale factor", new Measure(1.0, Unit.UNIT)), new Parameter("latitude of origin", new Measure(0.0, Unit.DEGREE))};
    Ellipsoid ellipsoid;
    final Map<String, Measure> parameters;

    public static ConcurrentHashMap<String, Measure> getDefaultParameters() {
        ConcurrentHashMap<String, Measure> parameters = new ConcurrentHashMap<String, Measure>();
        for (Parameter param : DEFAULT_PARAMETERS) {
            parameters.put(param.getName(), param.getMeasure());
        }
        return parameters;
    }

    protected Projection(Identifier identifier, Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(identifier);
        this.ellipsoid = ellipsoid;
        if (parameters == null) {
            this.parameters = Collections.unmodifiableMap(new HashMap());
        } else {
            HashMap<String, Measure> lowerCaseMap = new HashMap<String, Measure>(parameters.size());
            for (Map.Entry<String, Measure> entry : parameters.entrySet()) {
                lowerCaseMap.put(entry.getKey().toLowerCase(), entry.getValue());
            }
            this.parameters = Collections.unmodifiableMap(lowerCaseMap);
        }
    }

    public double getSemiMajorAxis() {
        return this.ellipsoid.getSemiMajorAxis();
    }

    public double getSemiMinorAxis() {
        return this.ellipsoid.getSemiMinorAxis();
    }

    public double getCentralMeridian() {
        return this.parameters.get("central meridian").getSValue();
    }

    public double getLatitudeOfOrigin() {
        return this.parameters.get("latitude of origin").getSValue();
    }

    public double getStandardParallel1() {
        return this.parameters.get("standard parallel 1").getSValue();
    }

    public double getStandardParallel2() {
        return this.parameters.get("standard parallel 2").getSValue();
    }

    public double getLatitudeOfTrueScale() {
        return this.parameters.get("latitude of true scale").getSValue();
    }

    public double getAzimuth() {
        return this.parameters.get("azimuth").getSValue();
    }

    public double getRectifiedGridAngle() {
        return this.parameters.get("rectified grid angle").getSValue();
    }

    public double getScaleFactor() {
        Measure m = this.parameters.get("scale factor");
        return this.parameters.get("scale factor").getSValue();
    }

    public double getFalseEasting() {
        return this.parameters.get("false easting").getSValue();
    }

    public double getFalseNorthing() {
        return this.parameters.get("false northing").getSValue();
    }

    public abstract Surface getSurface();

    public abstract Property getProperty();

    public abstract Orientation getOrientation();

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        throw new NonInvertibleOperationException(this.toString() + " is non invertible");
    }

    public boolean isDirect() {
        return true;
    }

    public String toWKT(Unit unit) {
        StringBuilder w = new StringBuilder();
        w.append("PROJECTION[\"");
        w.append(this.getName());
        w.append("\"],PARAMETER[\"").append("latitude of origin").append("\",");
        w.append(PrjWriter.prettyRound(AngleFormat.rad2deg(this.getLatitudeOfOrigin()), 1.0E-11));
        if (this.getStandardParallel1() != 0.0) {
            w.append("],PARAMETER[\"").append("standard parallel 1").append("\",");
            w.append(PrjWriter.prettyRound(AngleFormat.rad2deg(this.getStandardParallel1()), 1.0E-11));
        }
        if (this.getStandardParallel2() != 0.0) {
            w.append("],PARAMETER[\"").append("standard parallel 2").append("\",");
            w.append(PrjWriter.prettyRound(AngleFormat.rad2deg(this.getStandardParallel2()), 1.0E-11));
        }
        w.append("],PARAMETER[\"").append("central meridian").append("\",");
        w.append(PrjWriter.prettyRound(AngleFormat.rad2deg(this.getCentralMeridian()), 1.0E-11));
        if (this.getAzimuth() != 0.0) {
            w.append("],PARAMETER[\"").append("azimuth").append("\",");
            w.append(PrjWriter.prettyRound(AngleFormat.rad2deg(this.getAzimuth()), 1.0E-11));
        }
        if (this.getRectifiedGridAngle() != 0.0) {
            w.append("],PARAMETER[\"").append("rectified grid angle").append("\",");
            w.append(PrjWriter.prettyRound(AngleFormat.rad2deg(this.getRectifiedGridAngle()), 1.0E-11));
        }
        w.append("],PARAMETER[\"").append("scale factor").append("\",");
        w.append(PrjWriter.prettyRound(this.getScaleFactor(), 1.0E-16));
        w.append("],PARAMETER[\"").append("false easting").append("\",");
        w.append(PrjWriter.prettyRound(this.getFalseEasting() / unit.getScale(), 1.0E-5));
        w.append("],PARAMETER[\"").append("false northing").append("\",");
        w.append(PrjWriter.prettyRound(this.getFalseNorthing() / unit.getScale(), 1.0E-5));
        w.append("]");
        return w.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Projection) {
            Projection proj = (Projection)o;
            if (this.toString() != null) {
                if (this.getClass().equals(proj.getClass())) {
                    for (String param : this.parameters.keySet()) {
                        if (this.parameters.get(param) == null && proj.parameters.get(param) == null) continue;
                        if (this.parameters.get(param) == null && proj.parameters.get(param) != null) {
                            return false;
                        }
                        if (this.parameters.get(param) != null && proj.parameters.get(param) == null || this.parameters.get(param).equals(proj.parameters.get(param)) || this.parameters.get(param).equals(proj.parameters.get(param))) continue;
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + (this.ellipsoid != null ? this.ellipsoid.hashCode() : 0);
        hash = 73 * hash + (this.parameters != null ? this.parameters.hashCode() : 0);
        return hash;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Orientation {
        OBLIQUE,
        SECANT,
        TANGENT,
        TRANSVERSE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        APHYLACTIC,
        CONFORMAL,
        EQUAL_AREA,
        EQUIDISTANT,
        GNOMONIC;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Surface {
        AZIMUTHAL,
        CONICAL,
        CYLINDRICAL,
        HYBRID,
        MISCELLANEOUS,
        POLYCONICAL,
        PSEUDOAZIMUTHAL,
        PSEUDOCONICAL,
        PSEUDOCYLINDRICAL,
        RETROAZIMUTHAL;

    }
}

