/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.semanticweb.owlapi.krss2.renderer.KRSS2Vocabulary;
import org.semanticweb.owlapi.krss2.renderer.KRSSObjectRenderer;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;

public class KRSS2ObjectRenderer
extends KRSSObjectRenderer {
    private final Set<OWLSubPropertyChainOfAxiom> leftRightIdentityUsed = new HashSet<OWLSubPropertyChainOfAxiom>();
    protected boolean ignoreDeclarations = false;

    public KRSS2ObjectRenderer(OWLOntology ontology, Writer writer) {
        super(ontology, writer);
    }

    protected static boolean isLeftIdentityAxiom(OWLSubPropertyChainOfAxiom axiom, OWLObjectProperty property) {
        if (axiom.getSuperProperty().equals(property)) {
            List propertyChain = axiom.getPropertyChain();
            if (propertyChain.size() < 3) {
                return false;
            }
            if (((OWLObjectPropertyExpression)propertyChain.get(0)).isOWLObjectProperty() && ((OWLObjectPropertyExpression)propertyChain.get(1)).equals(property)) {
                return propertyChain.size() > 2;
            }
        }
        return false;
    }

    protected static boolean isRightIdentityAxiom(OWLSubPropertyChainOfAxiom axiom, OWLObjectProperty property) {
        if (axiom.getSuperProperty().equals(property)) {
            List propertyChain = axiom.getPropertyChain();
            if (propertyChain.size() < 2) {
                return false;
            }
            if (((OWLObjectPropertyExpression)propertyChain.get(0)).equals(property)) {
                return propertyChain.size() > 2;
            }
        }
        return false;
    }

    public void setIgnoreDeclarations(boolean ignoreDeclarations) {
        this.ignoreDeclarations = ignoreDeclarations;
    }

    @Override
    protected void write(KRSS2Vocabulary v) {
        this.write(v.toString());
    }

    @Override
    public void visit(OWLOntology ontology) {
        this.reset();
        for (OWLClass eachClass : OWLAPIStreamUtils.asList((Stream)ontology.classesInSignature())) {
            if (this.ignoreDeclarations && ontology.axioms(eachClass).count() == 1L && ontology.declarationAxioms((OWLEntity)eachClass).count() == 1L) continue;
            boolean primitive = !EntitySearcher.isDefined((OWLClass)eachClass, (OWLOntology)ontology);
            this.writeOpenBracket();
            if (primitive) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write((OWLClassExpression)eachClass);
                this.writeSpace();
                this.flatten(CollectionFactory.sortOptionally((Stream)Searcher.sup((Stream)ontology.axioms(Filters.subClassWithSub, (Object)eachClass, Imports.INCLUDED), OWLClassExpression.class)));
                this.writeCloseBracket();
                this.writeln();
                List classes = OWLAPIStreamUtils.asList((Stream)Searcher.equivalent((Stream)ontology.equivalentClassesAxioms(eachClass), OWLClassExpression.class));
                for (OWLClassExpression description : classes) {
                    this.writeOpenBracket();
                    this.write((OWLClassExpression)eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.write(description);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write((OWLClassExpression)eachClass);
            this.flatten(CollectionFactory.sortOptionally((Stream)Searcher.equivalent((Stream)ontology.equivalentClassesAxioms(eachClass), OWLClassExpression.class)));
            this.writeCloseBracket();
            this.writeln();
            List supclasses = OWLAPIStreamUtils.asList((Stream)Searcher.sup((Stream)ontology.subClassAxiomsForSubClass(eachClass), OWLClassExpression.class));
            for (OWLClassExpression description : supclasses) {
                this.writeOpenBracket();
                this.write((OWLClassExpression)eachClass);
                this.write(KRSS2Vocabulary.IMPLIES);
                this.write(description);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLObjectProperty property : CollectionFactory.sortOptionally((Stream)ontology.objectPropertiesInSignature())) {
            List stream;
            Iterator inverses;
            if (this.ignoreDeclarations && ontology.axioms((OWLObjectPropertyExpression)property, Imports.EXCLUDED).count() == 1L && ontology.declarationAxioms((OWLEntity)property).count() == 1L) continue;
            this.writeOpenBracket();
            Stream streamp = Searcher.equivalent((Stream)ontology.equivalentObjectPropertiesAxioms((OWLObjectPropertyExpression)property));
            List properties = OWLAPIStreamUtils.asList((Stream)streamp);
            boolean isPrimitive = properties.isEmpty();
            if (isPrimitive) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write((OWLPropertyExpression)property);
                List superProperties = CollectionFactory.sortOptionally((Stream)Searcher.sup((Stream)ontology.axioms(Filters.subObjectPropertyWithSub, (Object)property, Imports.INCLUDED), OWLObjectPropertyExpression.class));
                int superSize = superProperties.size();
                if (superSize == 1) {
                    this.writeSpace();
                    this.write(KRSS2Vocabulary.PARENT_ATTR);
                    this.writeSpace();
                    this.write((OWLPropertyExpression)superProperties.iterator().next());
                } else if (superSize > 1) {
                    this.writeSpace();
                    this.write(KRSS2Vocabulary.PARENTS_ATTR);
                    this.writeSpace();
                    this.flattenProperties(superProperties, null);
                } else {
                    Collection<OWLSubPropertyChainOfAxiom> chainAxioms = this.getPropertyChainSubPropertyAxiomsFor((OWLPropertyExpression)property);
                    if (chainAxioms.size() == 1) {
                        OWLSubPropertyChainOfAxiom axiom = chainAxioms.iterator().next();
                        if (KRSS2ObjectRenderer.isLeftIdentityAxiom(axiom, property)) {
                            this.leftRightIdentityUsed.add(axiom);
                            this.writeSpace();
                            this.write(KRSS2Vocabulary.LEFTIDENTITY_ATTR);
                            this.write((OWLPropertyExpression)axiom.getPropertyChain().get(0));
                        } else if (KRSS2ObjectRenderer.isRightIdentityAxiom(axiom, property)) {
                            this.leftRightIdentityUsed.add(axiom);
                            this.writeSpace();
                            this.write(KRSS2Vocabulary.RIGHTIDENTITY_ATTR);
                            this.write((OWLPropertyExpression)axiom.getPropertyChain().get(1));
                        }
                    }
                }
            } else if (properties.isEmpty()) {
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
                this.write((OWLPropertyExpression)property);
                this.writeSpace();
            } else {
                this.write(KRSS2Vocabulary.DEFINE_ROLE);
                this.write((OWLPropertyExpression)property);
                OWLObjectPropertyExpression expr = (OWLObjectPropertyExpression)properties.iterator().next();
                this.write((OWLPropertyExpression)expr);
                properties.remove(expr);
                this.writeSpace();
            }
            if (EntitySearcher.isTransitive((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isSymmetric((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isReflexive((OWLObjectPropertyExpression)property, (OWLOntology)ontology)) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.REFLEXIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(inverses = Searcher.inverse((Stream)ontology.inverseObjectPropertyAxioms((OWLObjectPropertyExpression)property), (OWLObjectPropertyExpression)property).iterator()).hasNext()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.INVERSE_ATTR);
                this.write((OWLPropertyExpression)inverses.next());
            }
            if (!(stream = CollectionFactory.sortOptionally((Stream)Searcher.domain((Stream)ontology.objectPropertyDomainAxioms((OWLObjectPropertyExpression)property)))).isEmpty()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.DOMAIN_ATTR);
                this.flatten(stream);
            }
            if (!(stream = CollectionFactory.sortOptionally((Stream)Searcher.range((Stream)ontology.objectPropertyRangeAxioms((OWLObjectPropertyExpression)property)))).isEmpty()) {
                this.writeSpace();
                this.write(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(stream);
            }
            this.writeCloseBracket();
            this.writeln();
            while (inverses.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.INVERSE);
                this.write((OWLPropertyExpression)property);
                this.write((OWLPropertyExpression)inverses.next());
                this.writeOpenBracket();
                this.writeln();
            }
            for (OWLObjectPropertyExpression expr : properties) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.ROLES_EQUIVALENT);
                this.write((OWLPropertyExpression)property);
                this.write((OWLPropertyExpression)expr);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLNamedIndividual individual : CollectionFactory.sortOptionally((Stream)ontology.individualsInSignature())) {
            if (this.ignoreDeclarations && ontology.axioms((OWLIndividual)individual, Imports.EXCLUDED).count() == 1L && ontology.declarationAxioms((OWLEntity)individual).count() == 1L) continue;
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_INDIVIDUAL);
            this.write((OWLIndividual)individual);
            this.writeCloseBracket();
            this.writeln();
        }
        ontology.axioms().forEach(a -> a.accept((OWLObjectVisitor)this));
        this.writer.flush();
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        if (!(axiom.getSubClass() instanceof OWLClass)) {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.IMPLIES);
            this.write(axiom.getSubClass());
            this.write(axiom.getSuperClass());
            this.writeCloseBracket();
            this.writeln();
        }
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        OWLAPIStreamUtils.pairs((Stream)axiom.properties()).forEach(v -> {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.ROLES_EQUIVALENT);
            this.write((OWLPropertyExpression)v.i);
            this.write((OWLPropertyExpression)v.j);
            this.writeCloseBracket();
            this.writeln();
        });
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        OWLAPIStreamUtils.pairs((Stream)axiom.properties()).forEach(v -> {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DISJOINT_ROLES);
            this.write((OWLPropertyExpression)v.i);
            this.write((OWLPropertyExpression)v.j);
            this.writeCloseBracket();
            this.writeln();
        });
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        if (!((OWLObjectPropertyExpression)axiom.getSubProperty()).isOWLObjectProperty()) {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.IMPLIES_ROLE);
            this.write(axiom.getSubProperty());
            this.write(axiom.getSuperProperty());
            this.writeCloseBracket();
            this.writeln();
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        OWLAPIStreamUtils.pairs((Stream)axiom.classExpressions()).forEach(v -> {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.EQUIVALENT);
            this.write((OWLClassExpression)v.i);
            this.write((OWLClassExpression)v.j);
            this.writeCloseBracket();
            this.writeln();
        });
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        if (this.leftRightIdentityUsed.contains(axiom)) {
            return;
        }
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ROLE_INCLUSTION);
        this.writeSpace();
        this.writeChain(axiom.getPropertyChain(), 0);
        this.writeSpace();
        this.write((OWLPropertyExpression)axiom.getSuperProperty());
        this.writeCloseBracket();
        this.writeln();
    }

    protected void writeChain(List<OWLObjectPropertyExpression> expressions, int i) {
        if (i == expressions.size() - 1) {
            this.write((OWLPropertyExpression)expressions.get(i));
        } else {
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.COMPOSE);
            this.write((OWLPropertyExpression)expressions.get(i));
            this.writeChain(expressions, i + 1);
            this.writeCloseBracket();
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
        this.writeln();
    }

    public void visit(OWLObjectOneOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ONE_OF);
        ce.individuals().forEach(this::write);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INV);
        this.writeSpace();
        property.getInverseProperty();
        property.getInverse().accept((OWLObjectVisitor)this);
        this.writeCloseBracket();
    }

    protected Collection<OWLSubPropertyChainOfAxiom> getPropertyChainSubPropertyAxiomsFor(OWLPropertyExpression property) {
        return OWLAPIStreamUtils.asList(this.ont.axioms(AxiomType.SUB_PROPERTY_CHAIN_OF).filter(a -> a.getSuperProperty().equals(property)));
    }

    protected void reset() {
        this.leftRightIdentityUsed.clear();
    }
}

