/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.AlterViewFinalStep;
import org.jooq.AlterViewStep;
import org.jooq.Clause;
import org.jooq.Comment;
import org.jooq.Configuration;
import org.jooq.Context;
import org.jooq.Name;
import org.jooq.SQLDialect;
import org.jooq.Table;
import org.jooq.impl.AbstractRowCountQuery;
import org.jooq.impl.DDLStatementType;
import org.jooq.impl.DSL;
import org.jooq.impl.Keywords;
import org.jooq.impl.Tools;

final class AlterViewImpl
extends AbstractRowCountQuery
implements AlterViewStep,
AlterViewFinalStep {
    private static final long serialVersionUID = 8904572826501186329L;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_VIEW};
    private static final Set<SQLDialect> SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD);
    private final Table<?> view;
    private final boolean ifExists;
    private Comment comment;
    private Table<?> renameTo;

    AlterViewImpl(Configuration configuration, Table<?> view) {
        this(configuration, view, false);
    }

    AlterViewImpl(Configuration configuration, Table<?> view, boolean ifExists) {
        super(configuration);
        this.view = view;
        this.ifExists = ifExists;
    }

    final Table<?> $view() {
        return this.view;
    }

    final boolean $ifExists() {
        return this.ifExists;
    }

    final Table<?> $renameTo() {
        return this.renameTo;
    }

    @Override
    public final AlterViewImpl comment(String c) {
        return this.comment(DSL.comment(c));
    }

    @Override
    public final AlterViewImpl comment(Comment c) {
        this.comment = c;
        return this;
    }

    @Override
    public final AlterViewImpl renameTo(Table<?> newName) {
        this.renameTo = newName;
        return this;
    }

    @Override
    public final AlterViewImpl renameTo(Name newName) {
        return this.renameTo((Table)DSL.table(newName));
    }

    @Override
    public final AlterViewImpl renameTo(String newName) {
        return this.renameTo(DSL.name(newName));
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.beginTryCatch(ctx, DDLStatementType.ALTER_VIEW);
            this.accept0(ctx);
            Tools.endTryCatch(ctx, DDLStatementType.ALTER_VIEW);
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        if (this.comment != null) {
            ctx.visit(DSL.commentOnView(this.view).is(this.comment));
            return;
        }
        this.accept1(ctx);
    }

    private final void accept1(Context<?> ctx) {
        ctx.start(Clause.ALTER_VIEW_VIEW).visit(Keywords.K_ALTER).sql(' ').visit(ctx.family() == SQLDialect.HSQLDB ? Keywords.K_TABLE : Keywords.K_VIEW);
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
        }
        ctx.sql(' ').visit(this.view).end(Clause.ALTER_VIEW_VIEW).formatIndentStart().formatSeparator();
        if (this.renameTo != null) {
            boolean qualify = ctx.qualify();
            ctx.start(Clause.ALTER_VIEW_RENAME).qualify(false).visit(Keywords.K_RENAME_TO).sql(' ').visit(this.renameTo).qualify(qualify).end(Clause.ALTER_VIEW_RENAME);
        }
        ctx.formatIndentEnd();
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }
}

