/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.Set;
import org.jooq.Context;
import org.jooq.Field;
import org.jooq.SQLDialect;
import org.jooq.impl.AbstractField;
import org.jooq.impl.DSL;
import org.jooq.impl.Names;
import org.jooq.impl.SQLDataType;

final class ToChar
extends AbstractField<String> {
    private static final long serialVersionUID = 2484479701190490450L;
    private static final Set<SQLDialect> SUPPORT_NATIVE_WITHOUT_MASK = SQLDialect.supportedBy(SQLDialect.H2);
    private static final Set<SQLDialect> SUPPORT_NATIVE_WITH_MASK = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES);
    private final Field<?> field;
    private final Field<String> format;

    ToChar(Field<?> field, Field<String> format) {
        super(Names.N_TO_CHAR, SQLDataType.VARCHAR);
        this.field = field;
        this.format = format;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.format == null && !SUPPORT_NATIVE_WITHOUT_MASK.contains((Object)ctx.dialect())) {
            this.acceptCast(ctx);
        } else if (this.format != null && !SUPPORT_NATIVE_WITH_MASK.contains((Object)ctx.dialect())) {
            this.acceptCast(ctx);
        } else {
            this.acceptNative(ctx);
        }
    }

    private final void acceptNative(Context<?> ctx) {
        ctx.visit(Names.N_TO_CHAR).sql('(').visit(this.field);
        if (this.format != null) {
            ctx.sql(", ").visit(this.format);
        }
        ctx.sql(')');
    }

    private final void acceptCast(Context<?> ctx) {
        ctx.visit(DSL.cast(this.field, SQLDataType.VARCHAR));
    }
}

