/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.trans.bplustree;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.dboe.trans.bplustree.BPTreeNode;
import org.apache.jena.dboe.trans.bplustree.BPTreePage;

public class AccessPath {
    private final BPTreeNode root;
    private List<AccessStep> traversed = new ArrayList<AccessStep>();

    public AccessPath(BPTreeNode root) {
        this.root = root;
    }

    public void add(BPTreeNode node, int idx, BPTreePage page) {
        this.traversed.add(new AccessStep(node, idx, page));
    }

    public void reset(BPTreeNode node, int idx, BPTreePage page) {
        AccessStep s = this.traversed.remove(this.traversed.size() - 1);
        AccessStep s2 = new AccessStep(node, idx, page);
        if (s.node != s2.node) {
            throw new InternalErrorException("Bad attempt to reset: " + this + " with " + s2);
        }
        this.traversed.add(new AccessStep(node, idx, page));
    }

    public List<AccessStep> getPath() {
        return this.traversed;
    }

    public String toString() {
        return this.traversed.stream().map(x -> x.toString()).collect(Collectors.toList()).toString();
    }

    static class AccessStep {
        final BPTreeNode node;
        final int idx;
        final BPTreePage page;

        AccessStep(BPTreeNode node, int idx, BPTreePage page) {
            this.node = node;
            this.idx = idx;
            this.page = page;
        }

        public String toString() {
            return "(" + this.node.label() + ", " + this.idx + ")->" + this.page.getId();
        }
    }
}

