/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.remote;

import com.bigdata.rdf.sail.remote.BigdataSailRemoteRepository;
import com.bigdata.rdf.sail.webapp.client.RemoteRepositoryManager;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.openrdf.repository.sail.SailRepository;
import org.openrdf.sail.Sail;

public class BigdataSailFactory {
    public static final String BIGDATA_SAIL_INSTANCE = "com.bigdata.rdf.sail.BigdataSail";
    public static final String SAIL_PROVIDER = "com.bigdata.rdf.sail.remote.Provider";

    public static BigdataSailRemoteRepository connect(String host, int port) {
        return BigdataSailFactory.connect("http://" + host + ":" + port + "/" + "blazegraph");
    }

    public static BigdataSailRemoteRepository connect(String sparqlEndpointURL) {
        return new RemoteRepositoryManager().getRepositoryForURL(sparqlEndpointURL).getBigdataSailRemoteRepository();
    }

    @Deprecated
    public static String testServiceEndpointUrl(String serviceEndpoint) {
        return BigdataSailFactory.normalizeEndpoint(serviceEndpoint);
    }

    @Deprecated
    private static String normalizeEndpoint(String serviceEndpoint) {
        if (serviceEndpoint.endsWith("/sparql")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - "/sparql".length());
        }
        if (serviceEndpoint.endsWith("/sparql/")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - "/sparql/".length());
        }
        if (serviceEndpoint.endsWith("/blazegraph/")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - 1);
        }
        if (serviceEndpoint.endsWith("/blazegraph")) {
            return serviceEndpoint;
        }
        if (serviceEndpoint.contains("/blazegraph") && serviceEndpoint.endsWith("/")) {
            return serviceEndpoint.substring(0, serviceEndpoint.length() - 1);
        }
        if (serviceEndpoint.contains("/blazegraph")) {
            return serviceEndpoint;
        }
        if (serviceEndpoint.endsWith("/")) {
            return serviceEndpoint + "blazegraph";
        }
        return serviceEndpoint + "/" + "blazegraph";
    }

    public static SailRepository openRepository(String file) {
        return new SailRepository(BigdataSailFactory.openSail(file, false));
    }

    public static SailRepository openRepository(String file, boolean create) {
        return new SailRepository(BigdataSailFactory.openSail(file, create));
    }

    public static Sail openSail(String file) {
        return BigdataSailFactory.openSail(file, false);
    }

    public static Sail openSail(String file, boolean create) {
        if (!new File(file).exists()) {
            if (!create) {
                throw new IllegalArgumentException("journal does not exist at specified location");
            }
            return BigdataSailFactory.createSail(file, new Option[0]);
        }
        Properties props = new Properties();
        props.setProperty("com.bigdata.journal.AbstractJournal.file", file);
        Sail sail = BigdataSailFactory.getSailProviderInstance(props);
        return sail;
    }

    public static SailRepository createRepository(Option ... args) {
        return BigdataSailFactory.createRepository(new Properties(), null, args);
    }

    public static SailRepository createRepository(Properties props, Option ... args) {
        return BigdataSailFactory.createRepository(props, null, args);
    }

    public static SailRepository createRepository(String file, Option ... args) {
        return BigdataSailFactory.createRepository(new Properties(), file, args);
    }

    public static SailRepository createRepository(Properties props, String file, Option ... args) {
        return new SailRepository(BigdataSailFactory.createSail(props, file, args));
    }

    public static Sail createSail(Option ... args) {
        return BigdataSailFactory.createSail(new Properties(), null, args);
    }

    public static Sail createSail(String file, Option ... args) {
        return BigdataSailFactory.createSail(new Properties(), file, args);
    }

    public static Sail createSail(Properties props, String file, Option ... args) {
        LinkedList<Option> options = args != null ? Arrays.asList(args) : new LinkedList<Option>();
        BigdataSailFactory.checkArgs(file, options);
        if (file != null) {
            props.setProperty("com.bigdata.journal.AbstractJournal.file", file);
            props.setProperty("com.bigdata.journal.AbstractJournal.bufferMode", "DiskRW");
        } else {
            props.setProperty("com.bigdata.journal.AbstractJournal.bufferMode", "MemStore");
        }
        if (options.contains((Object)Option.Inference)) {
            props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.axiomsClass", "com.bigdata.rdf.axioms.OwlAxioms");
            props.setProperty("com.bigdata.rdf.sail.truthMaintenance", "true");
            props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.justify", "true");
        } else {
            props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.axiomsClass", "com.bigdata.rdf.axioms.NoAxioms");
            props.setProperty("com.bigdata.rdf.sail.truthMaintenance", "false");
            props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.justify", "false");
        }
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.textIndex", String.valueOf(options.contains((Object)Option.TextIndex)));
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.statementIdentifiers", String.valueOf(options.contains((Object)Option.RDR)));
        props.setProperty("com.bigdata.rdf.store.AbstractTripleStore.quads", String.valueOf(options.contains((Object)Option.Quads)));
        props.setProperty("com.bigdata.service.AbstractTransactionService.minReleaseAge", "1");
        props.setProperty("com.bigdata.btree.writeRetentionQueue.capacity", "4000");
        props.setProperty("com.bigdata.btree.BTree.branchingFactor", "128");
        props.setProperty("com.bigdata.namespace.kb.lex.com.bigdata.btree.BTree.branchingFactor", "400");
        props.setProperty("com.bigdata.namespace.kb.spo.com.bigdata.btree.BTree.branchingFactor", "1024");
        Sail sail = BigdataSailFactory.getSailProviderInstance(props);
        return sail;
    }

    protected static Sail getSailProviderInstance(Properties props) {
        String providerClass = System.getProperty(SAIL_PROVIDER, BIGDATA_SAIL_INSTANCE);
        try {
            Class<?> c = Class.forName(providerClass);
            Constructor<?> cons = c.getConstructor(Properties.class);
            Object object = cons.newInstance(props);
            Sail proxy = (Sail)object;
            return proxy;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    protected static void checkArgs(String file, List<Option> options) {
        if (options.contains((Object)Option.Inference) && options.contains((Object)Option.Quads)) {
            throw new IllegalArgumentException();
        }
        if (options.contains((Object)Option.RDR) && options.contains((Object)Option.Quads)) {
            throw new IllegalArgumentException();
        }
    }

    public static enum Option {
        Inference,
        Quads,
        RDR,
        TextIndex;

    }
}

