/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import com.bigdata.util.NV;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

public class MiniMime {
    private static final Logger log = Logger.getLogger(MiniMime.class);
    public final float q;
    private final String mimeType;
    private final List<NV> params = new LinkedList<NV>();

    public MiniMime(String s) {
        String[] b = s.split(";");
        this.mimeType = b[0].trim();
        float q = 1.0f;
        for (int i = 1; i < b.length; ++i) {
            String c = b[i];
            String[] d = c.split("=");
            if (d.length < 2) continue;
            this.params.add(new NV(d[0].trim(), d[1].trim()));
            if (!d[0].equals("q")) continue;
            q = Float.valueOf(d[1]).floatValue();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Considering: " + s + " :: q=" + q));
        }
        this.q = q;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getParam(String name, String def) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        for (NV nv : this.params) {
            if (!name.equals(nv.getName())) continue;
            return nv.getValue();
        }
        return def;
    }

    public String getContentEncoding() {
        return this.getParam("charset", null);
    }
}

