/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.federation.evaluation;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.Iteration;
import info.aduna.iteration.UnionIteration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.Union;
import org.openrdf.query.algebra.evaluation.EvaluationStrategy;
import org.openrdf.query.algebra.evaluation.TripleSource;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStrategyImpl;
import org.openrdf.query.algebra.evaluation.iterator.BadlyDesignedLeftJoinIterator;
import org.openrdf.sail.federation.algebra.NaryJoin;
import org.openrdf.sail.federation.algebra.OwnedTupleExpr;
import org.openrdf.sail.federation.evaluation.ParallelJoinCursor;
import org.openrdf.sail.federation.evaluation.ParallelLeftJoinCursor;
import org.openrdf.sail.federation.evaluation.RepositoryTripleSource;

public class FederationStrategy
extends EvaluationStrategyImpl {
    private final Executor executor;

    public FederationStrategy(Executor executor, TripleSource tripleSource, Dataset dataset) {
        super(tripleSource, dataset);
        this.executor = executor;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(TupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration<BindingSet, QueryEvaluationException> result = expr instanceof NaryJoin ? this.evaluate((NaryJoin)expr, bindings) : (expr instanceof OwnedTupleExpr ? this.evaluate((OwnedTupleExpr)expr, bindings) : super.evaluate(expr, bindings));
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Join join, BindingSet bindings) throws QueryEvaluationException {
        Object result = this.evaluate(join.getLeftArg(), bindings);
        int n = 2;
        for (int i = 1; i < n; ++i) {
            result = new ParallelJoinCursor((EvaluationStrategy)this, (CloseableIteration<BindingSet, QueryEvaluationException>)result, join.getRightArg());
            this.executor.execute((Runnable)result);
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(NaryJoin join, BindingSet bindings) throws QueryEvaluationException {
        assert (join.getNumberOfArguments() > 0);
        Object result = this.evaluate((TupleExpr)join.getArg(0), bindings);
        int n = join.getNumberOfArguments();
        for (int i = 1; i < n; ++i) {
            result = new ParallelJoinCursor((EvaluationStrategy)this, (CloseableIteration<BindingSet, QueryEvaluationException>)result, (TupleExpr)join.getArg(i));
            this.executor.execute((Runnable)result);
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(LeftJoin leftJoin, BindingSet bindings) throws QueryEvaluationException {
        ParallelLeftJoinCursor result;
        Set boundVars = bindings.getBindingNames();
        Set leftVars = leftJoin.getLeftArg().getBindingNames();
        Set optionalVars = leftJoin.getRightArg().getBindingNames();
        HashSet problemVars = new HashSet(boundVars);
        problemVars.retainAll(optionalVars);
        problemVars.removeAll(leftVars);
        if (problemVars.isEmpty()) {
            result = new ParallelLeftJoinCursor((EvaluationStrategy)this, leftJoin, bindings);
            this.executor.execute(result);
        } else {
            result = new BadlyDesignedLeftJoinIterator((EvaluationStrategy)this, leftJoin, bindings, problemVars);
        }
        return result;
    }

    public CloseableIteration<BindingSet, QueryEvaluationException> evaluate(Union union, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration[] iters = new CloseableIteration[]{this.evaluate(union.getLeftArg(), bindings), this.evaluate(union.getRightArg(), bindings)};
        return new UnionIteration((Iteration[])iters);
    }

    private CloseableIteration<BindingSet, QueryEvaluationException> evaluate(OwnedTupleExpr expr, BindingSet bindings) throws QueryEvaluationException {
        CloseableIteration result = expr.evaluate(this.dataset, bindings);
        if (result == null) {
            RepositoryTripleSource source = new RepositoryTripleSource(expr.getOwner());
            FederationStrategy eval = new FederationStrategy(this.executor, source, this.dataset);
            result = eval.evaluate(expr.getArg(), bindings);
        }
        return result;
    }
}

