/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.http;

import com.sun.jini.jeri.internal.http.Header;
import com.sun.jini.jeri.internal.http.StartLine;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class MessageWriter {
    private static final int CHUNK_SIZE = 512;
    private static final int START = 0;
    private static final int HEADER = 1;
    private static final int CONTENT = 2;
    private static final int DONE = 3;
    private final OutputStream out;
    private final OutputStream cout;
    private int state = 0;
    private Header header;

    MessageWriter(OutputStream out, boolean chunked) {
        this.out = out;
        this.cout = chunked ? new ChunkedOutputStream() : new ByteArrayOutputStream();
    }

    void writeStartLine(StartLine line) throws IOException {
        this.updateState(0, 1);
        line.write(this.out);
    }

    void writeHeader(Header header) throws IOException {
        this.updateState(1, 2);
        if (this.cout instanceof ChunkedOutputStream) {
            header.setField("Transfer-Encoding", "chunked");
            header.setField("Content-Length", null);
            header.write(this.out);
        } else {
            this.header = header;
        }
    }

    void writeContent(byte[] b, int off, int len) throws IOException {
        this.updateState(2, 2);
        this.cout.write(b, off, len);
    }

    void writeTrailer(Header trailer) throws IOException {
        this.updateState(2, 3);
        this.cout.close();
        if (this.cout instanceof ChunkedOutputStream) {
            if (trailer != null) {
                trailer.write(this.out);
            } else {
                MessageWriter.writeLine(this.out, "");
            }
        } else {
            ByteArrayOutputStream bout = (ByteArrayOutputStream)this.cout;
            this.header.merge(trailer);
            this.header.setField("Content-Length", Integer.toString(bout.size()));
            this.header.setField("Transfer-Encoding", null);
            this.header.write(this.out);
            bout.writeTo(this.out);
        }
        this.out.flush();
    }

    void flush() throws IOException {
        if (this.state == 3) {
            throw new IllegalStateException();
        }
        if (this.state == 2) {
            this.cout.flush();
        }
        this.out.flush();
    }

    static void writeLine(OutputStream out, String line) throws IOException {
        line = line + "\r\n";
        int len = line.length();
        for (int i = 0; i < len; ++i) {
            out.write(line.charAt(i));
        }
    }

    private void updateState(int oldState, int newState) {
        if (this.state != oldState) {
            throw new IllegalStateException();
        }
        this.state = newState;
    }

    private class ChunkedOutputStream
    extends OutputStream {
        private final byte[] buf = new byte[512];
        private int pos = 0;

        ChunkedOutputStream() {
        }

        public void write(int val) throws IOException {
            this.write(new byte[]{(byte)val}, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            while (len > 0) {
                int avail = this.buf.length - this.pos;
                if (avail > 0) {
                    int ncopy = Math.min(len, avail);
                    System.arraycopy(b, off, this.buf, this.pos, ncopy);
                    this.pos += ncopy;
                    off += ncopy;
                    len -= ncopy;
                    continue;
                }
                this.flush();
            }
        }

        public void flush() throws IOException {
            if (this.pos > 0) {
                MessageWriter.writeLine(MessageWriter.this.out, Integer.toString(this.pos, 16));
                MessageWriter.this.out.write(this.buf, 0, this.pos);
                MessageWriter.writeLine(MessageWriter.this.out, "");
                this.pos = 0;
            }
        }

        public void close() throws IOException {
            this.flush();
            MessageWriter.writeLine(MessageWriter.this.out, "0");
        }
    }
}

