/*
 * Decompiled with CFR 0.152.
 */
package net.jini.constraint;

import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.x500.X500Principal;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.ClientAuthentication;
import net.jini.core.constraint.ClientMaxPrincipal;
import net.jini.core.constraint.ClientMaxPrincipalType;
import net.jini.core.constraint.ClientMinPrincipal;
import net.jini.core.constraint.ClientMinPrincipalType;
import net.jini.core.constraint.Confidentiality;
import net.jini.core.constraint.ConstraintAlternatives;
import net.jini.core.constraint.Delegation;
import net.jini.core.constraint.DelegationAbsoluteTime;
import net.jini.core.constraint.DelegationRelativeTime;
import net.jini.core.constraint.Integrity;
import net.jini.core.constraint.InvocationConstraint;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.ServerAuthentication;
import net.jini.core.constraint.ServerMinPrincipal;
import net.jini.security.TrustVerifier;

public class ConstraintTrustVerifier
implements TrustVerifier {
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        if (obj == null || ctx == null) {
            throw new NullPointerException();
        }
        if (obj instanceof InvocationConstraint) {
            Class<?> c = obj.getClass();
            if (c == ServerAuthentication.class || c == ClientAuthentication.class || c == Confidentiality.class || c == Integrity.class || c == ClientMinPrincipalType.class || c == ClientMaxPrincipalType.class || c == Delegation.class || c == DelegationRelativeTime.class || c == DelegationAbsoluteTime.class) {
                return true;
            }
            if (c == ServerMinPrincipal.class) {
                return ConstraintTrustVerifier.trusted(((ServerMinPrincipal)obj).elements(), ctx);
            }
            if (c == ClientMinPrincipal.class) {
                return ConstraintTrustVerifier.trusted(((ClientMinPrincipal)obj).elements(), ctx);
            }
            if (c == ClientMaxPrincipal.class) {
                return ConstraintTrustVerifier.trusted(((ClientMaxPrincipal)obj).elements(), ctx);
            }
            if (c == ConstraintAlternatives.class) {
                return ConstraintTrustVerifier.trusted(((ConstraintAlternatives)obj).elements(), ctx);
            }
            return false;
        }
        if (obj instanceof BasicMethodConstraints) {
            return ConstraintTrustVerifier.trusted(((BasicMethodConstraints)obj).possibleConstraints(), ctx);
        }
        if (obj instanceof InvocationConstraints) {
            InvocationConstraints ic = (InvocationConstraints)obj;
            return ConstraintTrustVerifier.trusted(ic.requirements(), ctx) && ConstraintTrustVerifier.trusted(ic.preferences(), ctx);
        }
        if (obj instanceof Principal) {
            Class<?> c = obj.getClass();
            return c == X500Principal.class || c == KerberosPrincipal.class;
        }
        return false;
    }

    private static boolean trusted(Set set, TrustVerifier.Context ctx) throws RemoteException {
        return ConstraintTrustVerifier.trusted(set.iterator(), ctx);
    }

    private static boolean trusted(Iterator iter, TrustVerifier.Context ctx) throws RemoteException {
        while (iter.hasNext()) {
            if (ctx.isTrustedObject(iter.next())) continue;
            return false;
        }
        return true;
    }
}

