/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.jdbc.results;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.jdbc.JdbcCompatibility;
import org.apache.jena.jdbc.statements.JenaStatement;
import org.apache.jena.jdbc.utils.JdbcNodeUtils;

public abstract class JenaResultSet
implements ResultSet {
    private static final int DEFAULT_HOLDABILITY = 2;
    private SQLWarning warnings;
    private JenaStatement statement;
    private boolean wasNull = false;
    private int holdability = 2;
    private int compatibilityLevel = 5;

    public JenaResultSet(JenaStatement statement) throws SQLException {
        if (statement == null) {
            throw new SQLException("Statement for a Result Set cannot be null");
        }
        this.statement = statement;
        this.compatibilityLevel = JdbcCompatibility.normalizeLevel(this.statement.getJdbcCompatibilityLevel());
    }

    public JenaStatement getJenaStatement() {
        return this.statement;
    }

    public int getJdbcCompatibilityLevel() {
        return this.compatibilityLevel;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public final void clearWarnings() {
        this.warnings = null;
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public final int getHoldability() {
        return this.holdability;
    }

    @Override
    public final int getConcurrency() {
        return 1007;
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    protected Node getNode(int columnIndex) throws SQLException {
        return this.getNode(this.findColumnLabel(columnIndex));
    }

    protected abstract String findColumnLabel(int var1) throws SQLException;

    protected abstract Node getNode(String var1) throws SQLException;

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.findColumnLabel(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toDecimal(n);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getBoolean(this.findColumnLabel(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return false;
        }
        this.setNull(false);
        return JdbcNodeUtils.toBoolean(n);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getByte(this.findColumnLabel(columnIndex));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return 0;
        }
        this.setNull(false);
        return JdbcNodeUtils.toByte(n);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(this.findColumnLabel(columnIndex));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toDate(n);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.findColumnLabel(columnIndex));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return 0.0;
        }
        this.setNull(false);
        return JdbcNodeUtils.toDouble(n);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.findColumnLabel(columnIndex));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return 0.0f;
        }
        this.setNull(false);
        return JdbcNodeUtils.toFloat(n);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.findColumnLabel(columnIndex));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return 0;
        }
        this.setNull(false);
        return JdbcNodeUtils.toInt(n);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.findColumnLabel(columnIndex));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return 0L;
        }
        this.setNull(false);
        return JdbcNodeUtils.toLong(n);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getNString(this.findColumnLabel(columnIndex));
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toString(n);
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(this.findColumnLabel(columnIndex));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        int jdbcType = this.getMetaData().getColumnType(this.findColumn(columnLabel));
        this.setNull(false);
        switch (jdbcType) {
            case -16: 
            case -15: 
            case -8: 
            case -7: 
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 0: 
            case 2: 
            case 7: 
            case 70: 
            case 1111: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: 
            case 2006: 
            case 2009: 
            case 2011: {
                throw new SQLException("Unable to marhsal a RDF Node to the declared column type " + jdbcType);
            }
            case 16: {
                return JdbcNodeUtils.toBoolean(n);
            }
            case -5: {
                return JdbcNodeUtils.toLong(n);
            }
            case 91: {
                return JdbcNodeUtils.toDate(n);
            }
            case 3: {
                return JdbcNodeUtils.toDecimal(n);
            }
            case 8: {
                return JdbcNodeUtils.toDouble(n);
            }
            case 6: {
                return Float.valueOf(JdbcNodeUtils.toFloat(n));
            }
            case 4: {
                return JdbcNodeUtils.toInt(n);
            }
            case 2000: {
                return n;
            }
            case -9: 
            case 1: 
            case 12: {
                return JdbcNodeUtils.toString(n);
            }
            case 5: {
                return JdbcNodeUtils.toShort(n);
            }
            case 92: {
                return JdbcNodeUtils.toTime(n);
            }
            case 93: {
                return JdbcNodeUtils.toTimestamp(n);
            }
            case -6: {
                return JdbcNodeUtils.toByte(n);
            }
        }
        throw new SQLException("Unable to marshal a RDF Node to the declared unknown column type " + jdbcType);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getShort(this.findColumnLabel(columnIndex));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return 0;
        }
        this.setNull(false);
        return JdbcNodeUtils.toShort(n);
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getString(this.findColumnLabel(columnIndex));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toString(n);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(this.findColumnLabel(columnIndex));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toTime(n);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(this.findColumnLabel(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toTimestamp(n);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getURL(this.findColumnLabel(columnIndex));
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        Node n = this.getNode(columnLabel);
        if (n == null) {
            this.setNull(true);
            return null;
        }
        this.setNull(false);
        return JdbcNodeUtils.toURL(n);
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getBigDecimal() is supported");
    }

    @Override
    @Deprecated
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getBigDecimal() is supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getDate() is supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getDate() is supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getObject() is supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getObject() is supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getObject() is supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getObject() is supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement getStatement() {
        return this.statement;
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getTime() is supported");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getTime() is supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getTimestamp() is supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Only the single argument form of getTimestamp() is supported");
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    @Deprecated
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public final SQLWarning getWarnings() {
        return this.warnings;
    }

    protected void setWarning(SQLWarning warning) {
        if (this.warnings == null) {
            this.warnings = warning;
        } else {
            warning.setNextWarning(this.warnings);
            this.warnings = warning;
        }
    }

    protected void setWarning(String warning) {
        this.setWarning(new SQLWarning(warning));
    }

    protected void setWarning(String warning, Throwable cause) {
        this.setWarning(new SQLWarning(warning, cause));
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are forward-only");
    }

    @Override
    public void refreshRow() {
    }

    @Override
    public boolean rowDeleted() {
        return false;
    }

    @Override
    public boolean rowInserted() {
        return false;
    }

    @Override
    public boolean rowUpdated() {
        return false;
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Jena JDBC Result Sets are read-only");
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    protected void setNull(boolean wasNull) {
        this.wasNull = wasNull;
    }
}

