/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bfs;

import com.bigdata.bfs.DocumentHeader;
import com.bigdata.bfs.FileMetadataSchema;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class DocumentHeaderImpl
implements DocumentHeader {
    protected static Logger log = Logger.getLogger(DocumentHeaderImpl.class);
    private final Map<String, Object> properties;

    public DocumentHeaderImpl() {
        this.properties = new HashMap<String, Object>();
    }

    public DocumentHeaderImpl(DocumentHeader header) {
        this(header.asMap());
    }

    public DocumentHeaderImpl(Map<String, Object> metadata) {
        this.properties = new HashMap<String, Object>(metadata);
    }

    public void setId(String id) {
        this.properties.put(FileMetadataSchema.ID, id);
    }

    void getVersion(int version) {
        this.properties.put(FileMetadataSchema.VERSION, version);
    }

    public void setContentType(String contentType) {
        this.properties.put(FileMetadataSchema.CONTENT_TYPE, contentType);
    }

    public void setContentEncoding(String contentEncoding) {
        this.properties.put(FileMetadataSchema.CONTENT_ENCODING, contentEncoding);
    }

    @Override
    public String getId() {
        return (String)this.properties.get(FileMetadataSchema.ID);
    }

    @Override
    public int getVersion() {
        Integer version = (Integer)this.properties.get(FileMetadataSchema.VERSION);
        if (version == null) {
            throw new IllegalStateException("No version");
        }
        return version;
    }

    @Override
    public String getContentType() {
        return (String)this.properties.get(FileMetadataSchema.CONTENT_TYPE);
    }

    @Override
    public String getContentEncoding() {
        return (String)this.properties.get(FileMetadataSchema.CONTENT_ENCODING);
    }

    public void setProperty(String name, Object newValue) {
        this.properties.put(name, newValue);
    }

    @Override
    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean exists() {
        return false;
    }

    @Override
    public long getEarliestVersionCreateTime() {
        throw new IllegalStateException();
    }

    @Override
    public long getMetadataUpdateTime() {
        throw new IllegalStateException();
    }

    @Override
    public long getVersionCreateTime() {
        throw new IllegalStateException();
    }
}

