/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.controller;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.IVariableOrConstant;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.join.BaseJoinStats;
import com.bigdata.bop.join.HashJoinAnnotations;
import com.bigdata.bop.join.JVMHashJoinUtility;
import com.bigdata.bop.join.JoinAnnotations;
import com.bigdata.bop.join.JoinTypeEnum;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.sparql.ast.service.BigdataServiceCall;
import com.bigdata.rdf.sparql.ast.service.ExternalServiceCall;
import com.bigdata.rdf.sparql.ast.service.MockIVReturningServiceCall;
import com.bigdata.rdf.sparql.ast.service.RemoteServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCall;
import com.bigdata.rdf.sparql.ast.service.ServiceCallUtility;
import com.bigdata.rdf.sparql.ast.service.ServiceNode;
import com.bigdata.rdf.sparql.ast.service.ServiceRegistry;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import com.bigdata.relation.accesspath.UnsyncLocalOutputBuffer;
import com.bigdata.striterator.ChunkedArrayIterator;
import com.bigdata.striterator.Chunkerator;
import com.bigdata.util.InnerCause;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.SingleValueIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;
import org.eclipse.jetty.client.HttpClient;
import org.openrdf.query.BindingSet;

public class ServiceCallJoin
extends PipelineOp {
    private static final Logger log = Logger.getLogger(ServiceCallJoin.class);
    private static final long serialVersionUID = 1L;

    public ServiceCallJoin(ServiceCallJoin op) {
        super(op);
    }

    public ServiceCallJoin(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        this.getRequiredProperty(Annotations.SERVICE_NODE);
        this.getRequiredProperty(Annotations.NAMESPACE);
        this.getRequiredProperty(Annotations.TIMESTAMP);
        this.getRequiredProperty(Annotations.JOIN_VARS);
    }

    public ServiceCallJoin(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    @Override
    public BaseJoinStats newStats() {
        return new BaseJoinStats();
    }

    private static class ServiceCallChunk {
        public final BigdataURI serviceURI;
        public final ServiceCall<?> serviceCall;
        private IBindingSet[] chunk;
        private final List<IBindingSet> sourceSolutions;

        public ServiceCallChunk(BigdataURI serviceURI, ServiceCall<?> serviceCall, IBindingSet[] chunk) {
            if (serviceURI == null) {
                throw new IllegalArgumentException();
            }
            if (serviceCall == null) {
                throw new IllegalArgumentException();
            }
            if (chunk == null) {
                throw new IllegalArgumentException();
            }
            if (chunk.length == 0) {
                throw new IllegalArgumentException();
            }
            this.serviceURI = serviceURI;
            this.serviceCall = serviceCall;
            this.chunk = chunk;
            this.sourceSolutions = null;
        }

        public ServiceCallChunk(BigdataURI serviceURI, ServiceCall<?> serviceCall) {
            if (serviceURI == null) {
                throw new IllegalArgumentException();
            }
            if (serviceCall == null) {
                throw new IllegalArgumentException();
            }
            this.serviceURI = serviceURI;
            this.serviceCall = serviceCall;
            this.chunk = null;
            this.sourceSolutions = new LinkedList<IBindingSet>();
        }

        public void addSourceSolution(IBindingSet bset) {
            if (this.sourceSolutions == null) {
                throw new UnsupportedOperationException();
            }
            this.sourceSolutions.add(bset);
        }

        public IBindingSet[] getSourceSolutions() {
            if (this.chunk != null) {
                return this.chunk;
            }
            this.chunk = this.sourceSolutions.toArray(new IBindingSet[this.sourceSolutions.size()]);
            return this.chunk;
        }

        public int hashCode() {
            return this.serviceURI.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            ServiceCallChunk c = (ServiceCallChunk)o;
            return this.serviceURI.equals(c.serviceURI);
        }
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final ServiceCallJoin op;
        private final BOpContext<IBindingSet> context;
        private final AbstractTripleStore db;
        private final HttpClient cm;
        private final IVariableOrConstant<?> serviceRef;
        private final ServiceNode serviceNode;
        private final boolean silent;
        private final long timeout;
        private final Set<IVariable<?>> projectedVars;

        public ChunkTask(ServiceCallJoin op, BOpContext<IBindingSet> context) {
            if (op == null) {
                throw new IllegalArgumentException();
            }
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.op = op;
            this.context = context;
            this.serviceNode = (ServiceNode)op.getRequiredProperty(Annotations.SERVICE_NODE);
            this.serviceRef = this.serviceNode.getServiceRef().getValueExpression();
            String namespace = (String)op.getRequiredProperty(Annotations.NAMESPACE);
            long timestamp = (Long)op.getRequiredProperty(Annotations.TIMESTAMP);
            this.db = (AbstractTripleStore)context.getResource(namespace, timestamp);
            this.cm = context.getClientConnectionManager();
            this.silent = this.serviceNode.isSilent();
            this.timeout = this.serviceNode.getTimeout();
            this.projectedVars = this.serviceNode.getProjectedVars();
            if (this.projectedVars == null) {
                throw new AssertionError();
            }
        }

        @Override
        public Void call() throws Exception {
            if (this.serviceRef.isConstant()) {
                this.doServiceCallWithConstant();
            } else {
                this.doServiceCallWithExpression();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doServiceCallWithConstant() throws Exception {
            BigdataURI serviceURI = ServiceCallUtility.getConstantServiceURI(this.serviceRef);
            if (serviceURI == null) {
                throw new AssertionError();
            }
            ServiceCall<? extends Object> serviceCall = this.resolveService(serviceURI);
            try {
                ICloseableIterator<IBindingSet[]> sitr = this.context.getSource();
                while (sitr.hasNext()) {
                    IBindingSet[] chunk = (IBindingSet[])sitr.next();
                    ServiceCallChunk serviceCallChunk = new ServiceCallChunk(serviceURI, serviceCall, chunk);
                    FutureTask<Void> ft = new FutureTask<Void>(new ServiceCallTask(serviceCallChunk));
                    this.context.getExecutorService().execute(ft);
                    try {
                        ft.get(this.timeout, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException ex) {
                        if (this.silent) continue;
                        throw ex;
                    }
                    finally {
                        ft.cancel(true);
                    }
                }
                this.context.getSink().flush();
                return;
            }
            finally {
                this.context.getSource().close();
                this.context.getSink().close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doServiceCallWithExpression() throws Exception {
            try {
                ICloseableIterator<IBindingSet[]> sitr = this.context.getSource();
                while (sitr.hasNext()) {
                    HashMap<BigdataURI, ServiceCallChunk> serviceCallChunks = new HashMap<BigdataURI, ServiceCallChunk>();
                    IBindingSet[] chunk = (IBindingSet[])sitr.next();
                    for (int i = 0; i < chunk.length; ++i) {
                        IBindingSet bset = chunk[i];
                        BigdataURI serviceURI = ServiceCallUtility.getServiceURI(this.serviceRef, bset);
                        ServiceCallChunk serviceCallChunk = (ServiceCallChunk)serviceCallChunks.get(serviceURI);
                        if (serviceCallChunk == null) {
                            ServiceCall<? extends Object> serviceCall = this.resolveService(serviceURI);
                            serviceCallChunk = new ServiceCallChunk(serviceURI, serviceCall);
                            serviceCallChunks.put(serviceURI, serviceCallChunk);
                        }
                        serviceCallChunk.addSourceSolution(bset);
                    }
                    int nparallel = this.op.getMaxParallel();
                    LatchedExecutor executorService = new LatchedExecutor(this.context.getExecutorService(), nparallel);
                    ArrayList<FutureTask<Void>> tasks = new ArrayList<FutureTask<Void>>(serviceCallChunks.size());
                    try {
                        for (ServiceCallChunk serviceCallChunk : serviceCallChunks.values()) {
                            FutureTask<Void> ft = new FutureTask<Void>(new ServiceCallTask(serviceCallChunk));
                            tasks.add(ft);
                            executorService.execute(ft);
                        }
                        for (FutureTask futureTask : tasks) {
                            try {
                                futureTask.get(this.timeout, TimeUnit.MILLISECONDS);
                            }
                            catch (TimeoutException ex) {
                                futureTask.cancel(true);
                                if (this.silent) continue;
                                throw ex;
                            }
                        }
                    }
                    finally {
                        for (FutureTask futureTask : tasks) {
                            futureTask.cancel(true);
                        }
                    }
                }
                this.context.getSink().flush();
                return;
            }
            finally {
                this.context.getSource().close();
                this.context.getSink().close();
            }
        }

        private ServiceCall<? extends Object> resolveService(BigdataURI serviceURI) {
            ServiceCall<? extends Object> serviceCall = ServiceRegistry.getInstance().toServiceCall(this.db, this.cm, serviceURI, this.serviceNode, (BaseJoinStats)this.context.getStats());
            return serviceCall;
        }

        private class ServiceCallTask
        implements Callable<Void> {
            private final IBindingSet[] chunk;
            private final BigdataURI serviceURI;
            private final ServiceCall<?> serviceCall;

            public ServiceCallTask(ServiceCallChunk serviceCallChunk) {
                if (serviceCallChunk == null) {
                    throw new IllegalArgumentException();
                }
                this.serviceURI = serviceCallChunk.serviceURI;
                this.serviceCall = serviceCallChunk.serviceCall;
                this.chunk = serviceCallChunk.getSourceSolutions();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                UnsyncLocalOutputBuffer<IBindingSet> unsyncBuffer = new UnsyncLocalOutputBuffer<IBindingSet>(ChunkTask.this.op.getChunkCapacity(), ChunkTask.this.context.getSink());
                IBlockingBuffer<E[]> sink2 = ChunkTask.this.context.getSink();
                UnsyncLocalOutputBuffer unsyncBuffer2 = sink2 == null ? null : new UnsyncLocalOutputBuffer(ChunkTask.this.op.getChunkCapacity(), sink2);
                JVMHashJoinUtility state = new JVMHashJoinUtility(ChunkTask.this.op, ChunkTask.this.silent ? JoinTypeEnum.Optional : JoinTypeEnum.Normal);
                state.acceptSolutions((ICloseableIterator<IBindingSet[]>)new SingleValueIterator((Object)this.chunk), null);
                try (ICloseableIterator<IBindingSet[]> serviceSolutionItr = null;){
                    serviceSolutionItr = this.doServiceCall(this.serviceCall, this.chunk);
                    if (serviceSolutionItr != null) {
                        state.hashJoin(serviceSolutionItr, null, unsyncBuffer);
                    }
                }
                if (state.getJoinType().isOptional()) {
                    UnsyncLocalOutputBuffer<Object> outputBuffer = unsyncBuffer2 == null ? unsyncBuffer : unsyncBuffer2;
                    state.outputOptionals(outputBuffer);
                    if (sink2 != null) {
                        unsyncBuffer2.flush();
                        sink2.flush();
                    }
                }
                unsyncBuffer.flush();
                return null;
            }

            private ICloseableIterator<IBindingSet[]> doServiceCall(ServiceCall<? extends Object> serviceCall, IBindingSet[] left) throws Exception {
                try {
                    ICloseableIterator<IBindingSet> itr;
                    if (serviceCall instanceof BigdataServiceCall) {
                        itr = this.doBigdataServiceCall((BigdataServiceCall)serviceCall, left);
                    } else if (serviceCall instanceof ExternalServiceCall) {
                        itr = this.doExternalServiceCall((ExternalServiceCall)serviceCall, left);
                    } else if (serviceCall instanceof RemoteServiceCall) {
                        itr = this.doRemoteServiceCall((RemoteServiceCall)serviceCall, left);
                    } else if (serviceCall instanceof MockIVReturningServiceCall) {
                        itr = this.doExternalMockIVServiceCall((MockIVReturningServiceCall)serviceCall, left);
                    } else {
                        throw new AssertionError();
                    }
                    Chunkerator<IBindingSet> itr2 = new Chunkerator<IBindingSet>((Iterator<IBindingSet>)itr, ChunkTask.this.op.getChunkCapacity(), IBindingSet.class);
                    return itr2;
                }
                catch (Throwable t) {
                    if (ChunkTask.this.silent && !InnerCause.isInnerCause((Throwable)t, InterruptedException.class)) {
                        log.warn((Object)("Service call: serviceUri=" + this.serviceURI + " :" + t));
                        return null;
                    }
                    throw new RuntimeException(t);
                }
            }

            private ICloseableIterator<IBindingSet> doBigdataServiceCall(BigdataServiceCall serviceCall, IBindingSet[] left) throws Exception {
                return serviceCall.call(left);
            }

            private ICloseableIterator<IBindingSet> doExternalMockIVServiceCall(MockIVReturningServiceCall serviceCall, IBindingSet[] left) throws Exception {
                return this.doNonBigdataMockIVServiceCall(serviceCall, left);
            }

            private ICloseableIterator<IBindingSet> doExternalServiceCall(ExternalServiceCall serviceCall, IBindingSet[] left) throws Exception {
                return this.doNonBigdataSesameServiceCall(serviceCall, left);
            }

            private ICloseableIterator<IBindingSet> doRemoteServiceCall(RemoteServiceCall serviceCall, IBindingSet[] left) throws Exception {
                return this.doNonBigdataSesameServiceCall(serviceCall, left);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ICloseableIterator<IBindingSet> doNonBigdataSesameServiceCall(ServiceCall<BindingSet> serviceCall, IBindingSet[] left) throws Exception {
                LexiconRelation lex = ChunkTask.this.db.getLexiconRelation();
                BindingSet[] left2 = ServiceCallUtility.convert(lex, ChunkTask.this.projectedVars, left);
                LinkedList<Object> serviceResults = new LinkedList<Object>();
                try (ICloseableIterator<BindingSet> results = null;){
                    results = serviceCall.call((BindingSet[])left2);
                    while (results.hasNext()) {
                        serviceResults.add(results.next());
                    }
                }
                BindingSet[] serviceResultChunk = serviceResults.toArray(new BindingSet[serviceResults.size()]);
                IBindingSet[] bigdataSolutionChunk = ServiceCallUtility.resolve(ChunkTask.this.db, serviceResultChunk);
                return new ChunkedArrayIterator<IBindingSet>(bigdataSolutionChunk);
            }

            private ICloseableIterator<IBindingSet> doNonBigdataMockIVServiceCall(ServiceCall<IBindingSet> serviceCall, IBindingSet[] left) throws Exception {
                return serviceCall.call((IBindingSet[])left);
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String CONSTRAINTS = JoinAnnotations.CONSTRAINTS;
        public static final String SERVICE_NODE = ServiceCallJoin.class.getName() + ".serviceNode";
        public static final String NAMESPACE = ServiceCallJoin.class.getName() + ".namespace";
        public static final String TIMESTAMP = ServiceCallJoin.class.getName() + ".timestamp";
        public static final String JOIN_VARS = HashJoinAnnotations.JOIN_VARS;
    }
}

