/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.engine;

import com.bigdata.counters.CAT;
import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounterSetAccess;
import com.bigdata.counters.Instrument;

public class QueryEngineCounters
implements ICounterSetAccess {
    protected final CAT queryStartCount = new CAT();
    protected final CAT queryDoneCount = new CAT();
    protected final CAT queryErrorCount = new CAT();
    protected final CAT elapsedMillis = new CAT();
    protected final CAT blockedWorkQueueCount = new CAT();
    protected final CAT blockedWorkQueueRunningTotal = new CAT();
    protected final CAT bufferedChunkMessageCount = new CAT();
    protected final CAT bufferedChunkMessageBytesOnNativeHeap = new CAT();
    protected final CAT operatorActiveCount = new CAT();
    protected final CAT operatorStartCount = new CAT();
    protected final CAT operatorHaltCount = new CAT();
    protected final CAT deadlineQueueSize = new CAT();

    @Override
    public CounterSet getCounters() {
        CounterSet root = new CounterSet();
        root.addCounter("queryStartCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.queryStartCount.get());
            }
        });
        root.addCounter("queryDoneCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.queryDoneCount.get());
            }
        });
        root.addCounter("queryErrorCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.queryErrorCount.get());
            }
        });
        root.addCounter("operatorTasksPerQuery", new Instrument<Double>(){

            @Override
            public void sample() {
                long opCount = QueryEngineCounters.this.operatorHaltCount.get();
                long n = QueryEngineCounters.this.queryDoneCount.get();
                double d = n == 0L ? 0.0 : (double)opCount / (double)n;
                this.setValue(d);
            }
        });
        root.addCounter("queriesPerSecond", new Instrument<Double>(){

            @Override
            public void sample() {
                long ms = QueryEngineCounters.this.elapsedMillis.get();
                long n = QueryEngineCounters.this.queryDoneCount.get();
                double d = ms == 0L ? 0.0 : 1000.0 * (double)n / (double)ms;
                this.setValue(d);
            }
        });
        root.addCounter("blockedWorkQueueCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.blockedWorkQueueCount.get());
            }
        });
        root.addCounter("blockedWorkQueueRunningTotal", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.blockedWorkQueueRunningTotal.get());
            }
        });
        root.addCounter("bufferedChunkMessageCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.bufferedChunkMessageCount.get());
            }
        });
        root.addCounter("bufferedChunkMessageBytesOnNativeHeap", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.bufferedChunkMessageBytesOnNativeHeap.get());
            }
        });
        root.addCounter("operatorActiveCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.operatorActiveCount.get());
            }
        });
        root.addCounter("operatorStartCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.operatorStartCount.get());
            }
        });
        root.addCounter("operatorHaltCount", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.operatorHaltCount.get());
            }
        });
        root.addCounter("deadlineQueueSize", new Instrument<Long>(){

            @Override
            public void sample() {
                this.setValue(QueryEngineCounters.this.deadlineQueueSize.get());
            }
        });
        return root;
    }
}

