/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed;

import com.bigdata.bfs.BigdataFileSystem;
import com.bigdata.btree.IIndex;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.counters.CounterSet;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.IResourceLockService;
import com.bigdata.journal.TemporaryStore;
import com.bigdata.relation.locator.IResourceLocator;
import com.bigdata.service.DataService;
import com.bigdata.sparse.SparseRowStore;
import java.util.Iterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

class DelegateIndexManager
implements IIndexManager {
    private final DataService dataService;

    public DelegateIndexManager(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException();
        }
        this.dataService = dataService;
    }

    @Override
    public IIndex getIndex(String name, long timestamp) {
        return this.dataService.getResourceManager().getIndex(name, timestamp);
    }

    @Override
    public void dropIndex(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerIndex(IndexMetadata indexMetadata) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.dataService.getFederation().getExecutorService();
    }

    @Override
    public BigdataFileSystem getGlobalFileSystem() {
        return this.dataService.getFederation().getGlobalFileSystem();
    }

    @Override
    public SparseRowStore getGlobalRowStore() {
        return this.dataService.getFederation().getGlobalRowStore();
    }

    @Override
    public SparseRowStore getGlobalRowStore(long timestamp) {
        return this.dataService.getFederation().getGlobalRowStore(timestamp);
    }

    @Override
    public long getLastCommitTime() {
        return this.dataService.getFederation().getLastCommitTime();
    }

    @Override
    public IResourceLocator getResourceLocator() {
        return this.dataService.getFederation().getResourceLocator();
    }

    @Override
    public IResourceLockService getResourceLockService() {
        return this.dataService.getFederation().getResourceLockService();
    }

    @Override
    public TemporaryStore getTempStore() {
        return this.dataService.getFederation().getTempStore();
    }

    @Override
    public ScheduledFuture<?> addScheduledTask(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.dataService.getFederation().addScheduledTask(task, initialDelay, delay, unit);
    }

    @Override
    public boolean getCollectPlatformStatistics() {
        return this.dataService.getFederation().getCollectPlatformStatistics();
    }

    @Override
    public boolean getCollectQueueStatistics() {
        return this.dataService.getFederation().getCollectQueueStatistics();
    }

    @Override
    public int getHttpdPort() {
        return this.dataService.getFederation().getHttpdPort();
    }

    @Override
    public CounterSet getCounters() {
        return this.dataService.getFederation().getCounters();
    }

    public String toString() {
        return super.toString() + "{dataServiceUUID=" + this.dataService.getServiceUUID() + "}";
    }

    @Override
    public Iterator<String> indexNameScan(String prefix, long timestamp) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isGroupCommit() {
        return true;
    }
}

