/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.fed.shards;

import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.fed.shards.Bundle;
import com.bigdata.bop.fed.shards.IShardMapper;
import com.bigdata.bop.fed.shards.MapBindingSetsOverShardsBuffer;
import com.bigdata.bop.fed.shards.Splitter;
import com.bigdata.mdi.PartitionLocator;
import com.bigdata.relation.accesspath.IBuffer;
import com.bigdata.service.Split;
import com.bigdata.service.ndx.ISplitter;
import com.bigdata.striterator.IKeyOrder;
import java.util.LinkedList;
import org.apache.log4j.Logger;

class Algorithm_FullyBoundPredicate<E extends IBindingSet, F>
implements IShardMapper<E, F> {
    private static final transient Logger log = Logger.getLogger(Algorithm_FullyBoundPredicate.class);
    private final MapBindingSetsOverShardsBuffer<E, F> op;
    private final IKeyOrder keyOrder;
    private final ISplitter splitter;

    public Algorithm_FullyBoundPredicate(MapBindingSetsOverShardsBuffer<E, F> op, IKeyOrder<F> keyOrder) {
        this.op = op;
        this.keyOrder = keyOrder;
        this.splitter = new Splitter(op.getMetadataIndex(keyOrder));
    }

    @Override
    public void mapOverShards(Bundle<F>[] bundles) {
        byte[][] keys = new byte[bundles.length][];
        for (int i = 0; i < bundles.length; ++i) {
            keys[i] = bundles[i].fromKey;
        }
        LinkedList<Split> splits = this.splitter.splitKeys(this.op.timestamp, 0, bundles.length, keys);
        if (log.isTraceEnabled()) {
            log.trace((Object)("nsplits=" + splits.size() + ", pred=" + this.op.pred));
        }
        for (Split split : splits) {
            IBuffer<IBindingSet[]> sink = this.op.getBuffer((PartitionLocator)split.pmd);
            IBindingSet[] slice = new IBindingSet[split.ntuples];
            int j = 0;
            int i = split.fromIndex;
            while (i < split.toIndex) {
                IBindingSet bset;
                slice[j] = bset = bundles[i].bindingSet;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Mapping: keyOrder=" + this.keyOrder + ", bset=" + bset + " onto partitionId=" + split.pmd.getPartitionId()));
                }
                ++i;
                ++j;
            }
            sink.add(slice);
        }
    }
}

