/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.joinGraph.NoSolutionsException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PartitionedJoinGroup {
    private static final transient Logger log = Logger.getLogger(PartitionedJoinGroup.class);
    private final Set<IVariable<?>> joinGraphVars = new LinkedHashSet();
    private final List<IPredicate<?>> headPlan = new LinkedList();
    private final List<IPredicate<?>> joinGraph = new LinkedList();
    private final List<IConstraint> joinGraphConstraints = new LinkedList<IConstraint>();
    private final List<IPredicate<?>> tailPlan = new LinkedList();
    private final List<IConstraint> tailPlanConstraints = new LinkedList<IConstraint>();
    private final Map<Integer, List<IConstraint>> tailPlanConstraintMap = new LinkedHashMap<Integer, List<IConstraint>>();

    public Set<IVariable<?>> getJoinGraphVars() {
        return this.joinGraphVars;
    }

    public IPredicate<?>[] getJoinGraph() {
        return this.joinGraph.toArray(new IPredicate[this.joinGraph.size()]);
    }

    public IConstraint[] getJoinGraphConstraints() {
        int size = this.joinGraphConstraints.size();
        if (size == 0) {
            return IConstraint.EMPTY;
        }
        return this.joinGraphConstraints.toArray(new IConstraint[size]);
    }

    public IConstraint[] getJoinGraphConstraints(int[] pathIds, boolean pathIsComplete) {
        if (pathIds == null) {
            throw new IllegalArgumentException();
        }
        IPredicate[] path = new IPredicate[pathIds.length];
        for (int i = 0; i < pathIds.length; ++i) {
            int id = pathIds[i];
            IPredicate<?> p = null;
            for (IPredicate<?> tmp : this.joinGraph) {
                if (tmp.getId() != id) continue;
                p = tmp;
                break;
            }
            if (p == null) {
                throw new IllegalArgumentException("Not found: id=" + id);
            }
            if (p.isOptional()) {
                throw new AssertionError((Object)("Not expecting an optional predicate: " + p));
            }
            path[i] = p;
        }
        IConstraint[] constraints = this.joinGraphConstraints.toArray(new IConstraint[this.joinGraphConstraints.size()]);
        IConstraint[][] attachedConstraints = PartitionedJoinGroup.getJoinGraphConstraints(path, constraints, null, pathIsComplete);
        return attachedConstraints[pathIds.length - 1];
    }

    public static IConstraint[][] getJoinGraphConstraints(IPredicate<?>[] path, IConstraint[] joinGraphConstraints, IVariable<?>[] knownBoundVars, boolean pathIsComplete) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (path.length == 0) {
            throw new IllegalArgumentException();
        }
        IConstraint[][] ret = new IConstraint[path.length][];
        LinkedHashSet boundVars = new LinkedHashSet();
        if (knownBoundVars != null) {
            for (IVariable<?> v : knownBoundVars) {
                boundVars.add(v);
            }
        }
        LinkedHashSet<IConstraint> used = new LinkedHashSet<IConstraint>();
        for (int i = 0; i < path.length; ++i) {
            IPredicate<?> p = path[i];
            if (p == null) {
                throw new IllegalArgumentException();
            }
            LinkedList<IConstraint> constraints = new LinkedList<IConstraint>();
            Iterator<IVariable<?>> vitr = BOpUtility.getArgumentVariables(p);
            while (vitr.hasNext()) {
                IVariable<?> var = vitr.next();
                boundVars.add(var);
            }
            if (joinGraphConstraints != null) {
                for (IConstraint c : joinGraphConstraints) {
                    if (c == null) {
                        throw new IllegalArgumentException();
                    }
                    if (used.contains(c)) continue;
                    boolean attach = false;
                    if (pathIsComplete && i == path.length - 1) {
                        attach = true;
                    } else {
                        boolean allVarsBound = true;
                        Iterator<IVariable<?>> vitr2 = BOpUtility.getSpannedVariables(c);
                        while (vitr2.hasNext()) {
                            IVariable<?> var = vitr2.next();
                            if (boundVars.contains(var)) continue;
                            allVarsBound = false;
                            break;
                        }
                        attach = allVarsBound;
                    }
                    if (!attach) continue;
                    used.add(c);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Constraint attached at index " + i + " of " + path.length + ", bopId=" + p.getId() + ", constraint=" + c));
                    }
                    constraints.add(c);
                }
            }
            ret[i] = constraints.toArray(new IConstraint[constraints.size()]);
        }
        return ret;
    }

    public IPredicate<?>[] getTailPlan() {
        return this.tailPlan.toArray(new IPredicate[this.tailPlan.size()]);
    }

    public IConstraint[] getTailPlanConstraints(int bopId) {
        boolean found = false;
        for (IPredicate<?> p : this.tailPlan) {
            if (p.getId() != bopId) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException("No such predicate in tail plan: bopId=" + bopId);
        }
        List<IConstraint> constraints = this.tailPlanConstraintMap.get(bopId);
        if (constraints == null) {
            return new IConstraint[0];
        }
        return constraints.toArray(new IConstraint[constraints.size()]);
    }

    public static boolean canJoin(IPredicate<?> p1, IPredicate<?> p2) {
        if (p1 == null) {
            throw new IllegalArgumentException();
        }
        if (p2 == null) {
            throw new IllegalArgumentException();
        }
        Iterator<IVariable<?>> itr1 = BOpUtility.getArgumentVariables(p1);
        while (itr1.hasNext()) {
            IVariable<?> v1 = itr1.next();
            Iterator<IVariable<?>> itr2 = BOpUtility.getArgumentVariables(p2);
            while (itr2.hasNext()) {
                IVariable<?> v2 = itr2.next();
                if (v1 != v2) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can join: sharedVar=" + v1 + ", p1=" + p1 + ", p2=" + p2));
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No directly shared variable: p1=" + p1 + ", p2=" + p2));
        }
        return false;
    }

    public static boolean canJoinUsingConstraints(IPredicate<?>[] path, IPredicate<?> vertex, IConstraint[] constraints) {
        IConstraint[] vertexConstraints;
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (vertex == null) {
            throw new IllegalArgumentException();
        }
        if (path.length == 0) {
            throw new IllegalArgumentException();
        }
        for (IPredicate<?> p : path) {
            if (p == null) {
                throw new IllegalArgumentException();
            }
            if (vertex != p) continue;
            throw new IllegalArgumentException();
        }
        LinkedHashSet knownBound = new LinkedHashSet();
        for (IPredicate<?> p : path) {
            Iterator<IVariable<?>> vitr = BOpUtility.getArgumentVariables(p);
            while (vitr.hasNext()) {
                knownBound.add(vitr.next());
            }
        }
        Iterator<IVariable<?>> vitr = BOpUtility.getArgumentVariables(vertex);
        while (vitr.hasNext()) {
            IVariable<?> var = vitr.next();
            if (!knownBound.contains(var)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Can join: sharedVar=" + var + ", path=" + Arrays.toString(path) + ", vertex=" + vertex));
            }
            return true;
        }
        if (constraints == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No directly shared variable: path=" + Arrays.toString(path) + ", vertex=" + vertex));
            }
            return false;
        }
        IPredicate[] newPath = new IPredicate[path.length + 1];
        System.arraycopy(path, 0, newPath, 0, path.length);
        newPath[path.length] = vertex;
        IConstraint[][] constraintRunArray = PartitionedJoinGroup.getJoinGraphConstraints(newPath, constraints, null, true);
        for (IConstraint c : vertexConstraints = constraintRunArray[path.length]) {
            Iterator<IVariable<?>> vitr2 = BOpUtility.getSpannedVariables(c);
            while (vitr2.hasNext()) {
                IVariable<?> var = vitr2.next();
                if (!knownBound.contains(var)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Can join: sharedVar=" + var + ", path=" + Arrays.toString(path) + ", vertex=" + vertex + ", constraint=" + c));
                }
                return true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("No shared variable: path=" + Arrays.toString(path) + ", vertex=" + vertex + ", constraints=" + Arrays.toString(constraints)));
        }
        return false;
    }

    public PartitionedJoinGroup(IPredicate<?>[] sourcePreds, IConstraint[] constraints) {
        if (sourcePreds == null) {
            throw new IllegalArgumentException();
        }
        if (sourcePreds.length == 0) {
            throw new IllegalArgumentException();
        }
        if (constraints == null) {
            constraints = IConstraint.EMPTY;
        }
        for (IPredicate<?> iPredicate : sourcePreds) {
            if (iPredicate == null) {
                throw new IllegalArgumentException();
            }
            if (iPredicate.isOptional()) {
                if (iPredicate.getAccessPathExpander() != null && iPredicate.getAccessPathExpander().runFirst()) {
                    throw new IllegalStateException("runFirst is not compatible with optional: " + iPredicate);
                }
                this.tailPlan.add(iPredicate);
                continue;
            }
            if (iPredicate.getAccessPathExpander() != null && iPredicate.getAccessPathExpander().runFirst()) {
                this.headPlan.add(iPredicate);
            } else {
                this.joinGraph.add(iPredicate);
            }
            Iterator<IVariable<?>> vitr = BOpUtility.getArgumentVariables(iPredicate);
            while (vitr.hasNext()) {
                this.joinGraphVars.add(vitr.next());
            }
        }
        for (BOp bOp : constraints) {
            boolean allFound = true;
            Iterator<IVariable<?>> vitr = BOpUtility.getSpannedVariables(bOp);
            if (!vitr.hasNext()) {
                throw new RuntimeException("No variables in constraint: " + bOp);
            }
            while (vitr.hasNext()) {
                IVariable<?> var = vitr.next();
                if (this.joinGraphVars.contains(var)) continue;
                allFound = false;
                this.tailPlanConstraints.add((IConstraint)bOp);
                break;
            }
            if (!allFound) continue;
            this.joinGraphConstraints.add((IConstraint)bOp);
        }
        LinkedHashMap lastIndexOf = new LinkedHashMap();
        int indexOf = 0;
        for (IPredicate<?> iPredicate : this.tailPlan) {
            Iterator<IVariable<?>> vitr = BOpUtility.getArgumentVariables(iPredicate);
            while (vitr.hasNext()) {
                IVariable<?> var = vitr.next();
                lastIndexOf.put(var, indexOf);
            }
            ++indexOf;
        }
        for (IConstraint iConstraint : this.tailPlanConstraints) {
            Object tmp;
            Iterator<IVariable<?>> vitr = BOpUtility.getSpannedVariables(iConstraint);
            Object maxLastIndexOf = null;
            while (vitr.hasNext()) {
                IVariable<?> var = vitr.next();
                if (this.joinGraphVars.contains(var)) continue;
                tmp = (Integer)lastIndexOf.get(var);
                if (tmp == null) {
                    throw new NoSolutionsException("Variable is never bound: " + var);
                }
                if (maxLastIndexOf != null && (Integer)tmp <= (Integer)maxLastIndexOf) continue;
                maxLastIndexOf = tmp;
            }
            if (maxLastIndexOf == null) {
                throw new AssertionError((Object)("maxLastIndexOf is undefined: " + iConstraint));
            }
            int predId = this.tailPlan.get((Integer)maxLastIndexOf).getId();
            tmp = this.tailPlanConstraintMap.get(predId);
            if (tmp == null) {
                tmp = new LinkedList<IConstraint>();
                this.tailPlanConstraintMap.put(predId, (List<IConstraint>)tmp);
            }
            tmp.add(iConstraint);
        }
    }
}

