/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.joinGraph.rto;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstraint;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.ap.SampleIndex;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.joinGraph.rto.EdgeSample;
import com.bigdata.bop.joinGraph.rto.JGraph;
import com.bigdata.bop.joinGraph.rto.Path;
import com.bigdata.bop.joinGraph.rto.PathIds;
import com.bigdata.bop.joinGraph.rto.Vertex;
import com.bigdata.rdf.sparql.ast.eval.AST2BOpRTO;
import com.bigdata.util.concurrent.Haltable;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class JoinGraph
extends PipelineOp {
    private static final long serialVersionUID = 1L;

    public IPredicate<?>[] getVertices() {
        return (IPredicate[])this.getRequiredProperty(Annotations.VERTICES);
    }

    public IConstraint[] getConstraints() {
        return this.getProperty(Annotations.CONSTRAINTS, null);
    }

    public int getLimit() {
        return this.getProperty(Annotations.LIMIT, 100);
    }

    public int getNEdges() {
        return this.getProperty(Annotations.NEDGES, 2);
    }

    public SampleIndex.SampleType getSampleType() {
        return SampleIndex.SampleType.valueOf(this.getProperty(Annotations.SAMPLE_TYPE, Annotations.DEFAULT_SAMPLE_TYPE));
    }

    public Set<IVariable<?>> getDoneSet() {
        return (Set)this.getRequiredProperty(Annotations.DONE_SET);
    }

    public Path getPath(IRunningQuery q) {
        return (Path)q.getAttributes().get(this.getId() + "-" + Attributes.PATH);
    }

    public Map<PathIds, EdgeSample> getSamples(IRunningQuery q) {
        return (Map)q.getAttributes().get(this.getId() + "-" + Attributes.SAMPLES);
    }

    private void setPath(IRunningQuery q, Path p) {
        q.getAttributes().put(this.getId() + "-" + Attributes.PATH, p);
    }

    private void setSamples(IRunningQuery q, Map<PathIds, EdgeSample> samples) {
        q.getAttributes().put(this.getId() + "-" + Attributes.SAMPLES, samples);
    }

    public PipelineOp getQueryPlan(IRunningQuery q) {
        return (PipelineOp)q.getAttributes().get(this.getId() + "-" + Attributes.QUERY_PLAN);
    }

    private void setQueryPlan(IRunningQuery q, PipelineOp queryPlan) {
        q.getAttributes().put(this.getId() + "-" + Attributes.QUERY_PLAN, queryPlan);
    }

    public JoinGraph(JoinGraph op) {
        super(op);
    }

    public JoinGraph(BOp[] args, NV ... anns) {
        this(args, NV.asMap(anns));
    }

    public JoinGraph(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        IPredicate[] vertices = (IPredicate[])this.getProperty(Annotations.VERTICES);
        if (vertices == null) {
            throw new IllegalArgumentException(Annotations.VERTICES);
        }
        if (vertices.length == 0) {
            throw new IllegalArgumentException(Annotations.VERTICES);
        }
        if (this.getLimit() <= 0) {
            throw new IllegalArgumentException(Annotations.LIMIT);
        }
        if (this.getNEdges() <= 0) {
            throw new IllegalArgumentException(Annotations.NEDGES);
        }
        if (!this.isController()) {
            throw new IllegalArgumentException();
        }
        switch (this.getEvaluationContext()) {
            case CONTROLLER: {
                break;
            }
            default: {
                throw new IllegalArgumentException(Annotations.EVALUATION_CONTEXT + "=" + this.getEvaluationContext());
            }
        }
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new JoinGraphTask(context));
    }

    private static void runSubquery(BOpContext<IBindingSet> parentContext, PipelineOp queryOp) throws Exception {
        if (parentContext == null) {
            throw new IllegalArgumentException();
        }
        if (queryOp == null) {
            throw new IllegalArgumentException();
        }
        QueryEngine queryEngine = parentContext.getRunningQuery().getQueryEngine();
        ICloseableIterator<IBindingSet[]> subquerySolutionItr = null;
        IBindingSet[] bindingSets = BOpUtility.toArray(parentContext.getSource(), parentContext.getStats());
        AbstractRunningQuery runningSubquery = queryEngine.eval((BOp)queryOp, bindingSets);
        try {
            ((AbstractRunningQuery)parentContext.getRunningQuery()).addChild(runningSubquery);
            subquerySolutionItr = runningSubquery.iterator();
            long nout = BOpUtility.copy(subquerySolutionItr, parentContext.getSink(), null, null, null, null, null);
            runningSubquery.get();
        }
        catch (Throwable t) {
            if (Haltable.isTerminationByInterrupt(t)) {
                return;
            }
            throw new RuntimeException(parentContext.getRunningQuery().halt(t));
        }
        finally {
            runningSubquery.cancel(true);
            if (subquerySolutionItr != null) {
                subquerySolutionItr.close();
            }
        }
    }

    private class JoinGraphTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;

        JoinGraphTask(BOpContext<IBindingSet> context) {
            if (context == null) {
                throw new IllegalArgumentException();
            }
            this.context = context;
        }

        @Override
        public Void call() throws Exception {
            if (JoinGraph.this.getQueryPlan(this.context.getRunningQuery()) == null) {
                JGraph g = new JGraph(JoinGraph.this);
                LinkedHashMap<PathIds, EdgeSample> edgeSamples = new LinkedHashMap<PathIds, EdgeSample>();
                Path path = g.runtimeOptimizer(this.context.getRunningQuery().getQueryEngine(), edgeSamples);
                for (EdgeSample s : edgeSamples.values()) {
                    s.releaseSample();
                }
                for (Vertex v : g.getVertices()) {
                    if (v.sample == null) continue;
                    v.sample.releaseSample();
                }
                JoinGraph.this.setPath(this.context.getRunningQuery(), path);
                JoinGraph.this.setSamples(this.context.getRunningQuery(), edgeSamples);
                PipelineOp queryOp = AST2BOpRTO.compileJoinGraph(this.context.getRunningQuery().getQueryEngine(), JoinGraph.this, path);
                JoinGraph.this.setQueryPlan(this.context.getRunningQuery(), queryOp);
            }
            PipelineOp queryOp = JoinGraph.this.getQueryPlan(this.context.getRunningQuery());
            JoinGraph.runSubquery(this.context, queryOp);
            return null;
        }
    }

    public static interface Attributes {
        public static final String PATH = JoinGraph.class.getName() + ".path";
        public static final String SAMPLES = JoinGraph.class.getName() + ".samples";
        public static final String QUERY_PLAN = JoinGraph.class.getName() + ".queryPlan";
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String VERTICES = JoinGraph.class.getName() + ".vertices";
        public static final String CONSTRAINTS = JoinGraph.class.getName() + ".constraints";
        public static final String LIMIT = JoinGraph.class.getName() + ".limit";
        public static final int DEFAULT_LIMIT = 100;
        public static final String NEDGES = JoinGraph.class.getName() + ".nedges";
        public static final int DEFAULT_NEDGES = 2;
        public static final String SAMPLE_TYPE = JoinGraph.class.getName() + ".sampleType";
        public static final String DEFAULT_SAMPLE_TYPE = SampleIndex.SampleType.RANDOM.name();
        public static final String DONE_SET = JoinGraph.class.getName() + ".doneSet";
        public static final String JOIN_GROUP = JoinGraph.class.getName() + ".joinGroup";
        public static final String NT = JoinGraph.class.getName() + ".nt";
    }
}

