/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.bop.rdf.join;

import com.bigdata.bop.BOp;
import com.bigdata.bop.BOpContext;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IConstant;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.NV;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.impl.literal.NumericIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.relation.accesspath.IBlockingBuffer;
import cutthecrap.utils.striterators.ICloseableIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class MockTermResolverOp
extends PipelineOp {
    private static final Logger log = Logger.getLogger(MockTermResolverOp.class);
    private static final long serialVersionUID = 1L;

    public MockTermResolverOp(BOp[] args, Map<String, Object> annotations) {
        super(args, annotations);
        IVariable<?>[] vars = this.getVars();
        if (vars != null && vars.length == 0) {
            throw new IllegalArgumentException();
        }
        this.getRequiredProperty(Annotations.RELATION_NAME);
        this.getRequiredProperty(Annotations.TIMESTAMP);
    }

    public MockTermResolverOp(MockTermResolverOp op) {
        super(op);
    }

    public MockTermResolverOp(BOp[] args, NV ... annotations) {
        this(args, NV.asMap(annotations));
    }

    public MockTermResolverOp(BOp[] args, IVariable<?>[] vars, String namespace, long timestamp) {
        this(args, new NV(Annotations.VARS, vars), new NV(Annotations.RELATION_NAME, new String[]{namespace}), new NV(Annotations.TIMESTAMP, timestamp));
    }

    public IVariable<?>[] getVars() {
        return (IVariable[])this.getProperty(Annotations.VARS);
    }

    @Override
    public FutureTask<Void> eval(BOpContext<IBindingSet> context) {
        return new FutureTask<Void>(new ChunkTask(this, context));
    }

    private static void handleChunk(IVariable<?>[] required, LexiconRelation lex, IBindingSet[] chunk) {
        BigdataValue[] ivValsArr;
        if (log.isInfoEnabled()) {
            log.info((Object)("Fetched chunk: size=" + chunk.length + ", chunk=" + Arrays.toString(chunk)));
        }
        int initialCapacity = required == null ? chunk.length : (required.length == 0 ? 1 : chunk.length * required.length);
        LinkedHashMap ivMap = new LinkedHashMap(initialCapacity);
        IBindingSet[] arr$ = chunk;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            IBindingSet solution;
            IBindingSet bindingSet = solution = arr$[i$];
            assert (bindingSet != null);
            if (required == null) {
                for (Map.Entry entry : bindingSet) {
                    IV iv = (IV)((IConstant)entry.getValue()).get();
                    if (iv == null) {
                        throw new RuntimeException("NULL? : var=" + entry.getKey() + ", " + bindingSet);
                    }
                    MockTermResolverOp.collectIVsToResolve(iv, ivMap, lex);
                }
                continue;
            }
            for (IVariable<?> v : required) {
                IConstant c = bindingSet.get(v);
                if (c == null) continue;
                IV iv = (IV)c.get();
                if (iv == null) {
                    throw new RuntimeException("NULL? : var=" + v + ", " + bindingSet);
                }
                MockTermResolverOp.collectIVsToResolve(iv, ivMap, lex);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Processing " + ivMap.size() + " IVs, required=" + Arrays.toString(required)));
        }
        Collection ivVals = ivMap.values();
        for (BigdataValue bigdataValue : ivValsArr = ivVals.toArray(new BigdataValue[ivVals.size()])) {
            if (bigdataValue.getIV() != null && bigdataValue.getIV().isNullIV()) {
                bigdataValue.clearInternalValue();
            }
            if (lex.isInlineLiterals() || bigdataValue.getIV() == null || !bigdataValue.getIV().isLiteral()) continue;
            bigdataValue.clearInternalValue();
        }
        lex.addTerms(ivValsArr, ivValsArr.length, true);
        for (BigdataValue bigdataValue : ivValsArr) {
            IV iv = bigdataValue.getIV();
            if (iv == null) continue;
            iv.setValue(bigdataValue);
        }
        for (BigdataValue bigdataValue : chunk) {
            MockTermResolverOp.replaceInBindingSet(required, (IBindingSet)bigdataValue, ivMap);
        }
    }

    private static void collectIVsToResolve(IV<?, ?> iv, Map<IV<?, ?>, BigdataValue> ivMap, LexiconRelation lex) {
        if (iv.isNullIV() && iv.hasValue() && !iv.isInline()) {
            BigdataValue bdVal;
            Object ivVal = iv.getValue();
            if (ivVal instanceof BigdataValue && !(bdVal = (BigdataValue)ivVal).isRealIV()) {
                ivMap.put(iv, bdVal);
            }
        } else if (!lex.isInlineLiterals() && iv.isLiteral()) {
            ivMap.put(iv, (BigdataValue)((NumericIV)iv).asValue(lex));
        }
    }

    private static void replaceInBindingSet(IVariable<?>[] required, IBindingSet bindingSet, Map<IV<?, ?>, BigdataValue> ivMap) {
        if (bindingSet == null) {
            throw new IllegalArgumentException();
        }
        if (ivMap == null) {
            throw new IllegalArgumentException();
        }
        if (required != null) {
            for (IVariable<?> var : required) {
                BigdataValue value;
                IV iv;
                IConstant c = bindingSet.get(var);
                if (c == null || (iv = (IV)c.get()) == null || (value = ivMap.get(iv)) == null || value.getIV() == null) continue;
                bindingSet.set(var, new Constant<IV>(value.getIV()));
            }
        } else {
            for (Map.Entry entry : bindingSet) {
                Object boundValue = ((IConstant)entry.getValue()).get();
                if (!(boundValue instanceof IV)) continue;
                IV iv = (IV)boundValue;
                BigdataValue value = ivMap.get(iv);
                bindingSet.set((IVariable)entry.getKey(), new Constant<IV>(value.getIV()));
            }
        }
    }

    private static class ChunkTask
    implements Callable<Void> {
        private final BOpContext<IBindingSet> context;
        private final IVariable<?>[] vars;
        private final String namespace;
        private final long timestamp;

        ChunkTask(MockTermResolverOp op, BOpContext<IBindingSet> context) {
            this.context = context;
            this.vars = op.getVars();
            this.namespace = ((String[])op.getProperty(Annotations.RELATION_NAME))[0];
            this.timestamp = (Long)op.getProperty(Annotations.TIMESTAMP);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            BOpStats stats = this.context.getStats();
            ICloseableIterator<IBindingSet[]> itr = this.context.getSource();
            try (IBlockingBuffer<IBindingSet[]> sink = this.context.getSink();){
                LexiconRelation lex = (LexiconRelation)this.context.getResource(this.namespace, this.timestamp);
                while (itr.hasNext()) {
                    IBindingSet[] a = (IBindingSet[])itr.next();
                    stats.chunksIn.increment();
                    stats.unitsIn.add(a.length);
                    MockTermResolverOp.handleChunk(this.vars, lex, a);
                    sink.add(a);
                }
                sink.flush();
                Void void_ = null;
                return void_;
            }
        }
    }

    public static interface Annotations
    extends PipelineOp.Annotations {
        public static final String VARS = MockTermResolverOp.class.getName() + ".vars";
        public static final String RELATION_NAME = Predicate.Annotations.RELATION_NAME;
        public static final String TIMESTAMP = Predicate.Annotations.TIMESTAMP;
    }
}

