/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.IndexSegment;
import com.bigdata.btree.IndexSegmentStore;
import com.bigdata.btree.SeekEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class IndexSegmentDumpUtil {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                IndexSegmentDumpUtil.printUsage();
                return;
            }
            File file = new File(args[0]);
            IndexSegmentStore store = new IndexSegmentStore(file);
            System.err.println("checkpoint: " + store.getCheckpoint());
            IndexSegment ndxSegment = store.loadIndexSegment();
            long before = Runtime.getRuntime().freeMemory();
            System.err.println("free memory before loading first leaf: " + before);
            System.err.println("take your memory dump and then press enter to load the first leaf");
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String input = reader.readLine();
            IndexSegment.ImmutableLeafCursor cursor = ndxSegment.newLeafCursor(SeekEnum.First);
            IndexSegment.ImmutableNodeFactory.ImmutableLeaf leaf = cursor.first();
            long after = Runtime.getRuntime().freeMemory();
            long used = before - after;
            System.err.println("free memory after loading first leaf: " + after);
            System.err.println("free memory used loading first leaf: " + used);
            System.err.println("bytes on disk for root: " + store.getByteCount(store.getCheckpoint().addrRoot));
            System.err.println("bytes on disk for first leaf: " + store.getByteCount(store.getCheckpoint().addrFirstLeaf));
            System.err.println("take your memory dump and then press enter to end the program");
            input = reader.readLine();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("You must specify an index segment store file");
    }
}

