/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.ITuple;
import com.bigdata.btree.ITupleSerializer;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.IKeyBuilderFactory;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class NOPTupleSerializer
extends DefaultTupleSerializer {
    private static final long serialVersionUID = 2211020411074955099L;
    public static final transient ITupleSerializer INSTANCE = new NOPTupleSerializer(new DefaultKeyBuilderFactory(new Properties()));
    private static final transient byte VERSION0 = 0;
    private static final transient byte VERSION = 0;

    public NOPTupleSerializer() {
    }

    public NOPTupleSerializer(IKeyBuilderFactory keyBuilderFactory) {
        super(keyBuilderFactory);
    }

    @Override
    public byte[] serializeKey(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException();
        }
        if (obj instanceof byte[]) {
            return (byte[])obj;
        }
        return this.getKeyBuilder().reset().append(obj).getKey();
    }

    @Override
    public byte[] serializeVal(Object obj) {
        return (byte[])obj;
    }

    @Override
    public Object deserialize(ITuple tuple) {
        if (tuple == null) {
            throw new IllegalArgumentException();
        }
        return tuple.getValue();
    }

    @Override
    public Object deserializeKey(ITuple tuple) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        byte version = in.readByte();
        switch (version) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown version: " + version);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(0);
    }
}

