/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree;

import com.bigdata.btree.BaseIndexStats;
import com.bigdata.btree.ICheckpointProtocol;
import com.bigdata.btree.IIdentityAccess;
import com.bigdata.btree.ISimpleTreeIndexAccess;
import com.bigdata.btree.data.IAbstractNodeData;
import com.bigdata.btree.data.ILeafData;
import com.bigdata.rawstore.IRawStore;

public abstract class PageStats
extends BaseIndexStats {
    public long nvisited;
    public long nodeBytes;
    public long leafBytes;
    public long minNodeBytes;
    public long maxNodeBytes;
    public long minLeafBytes;
    public long maxLeafBytes;
    public final long[] histogram = new long[SLOT_SIZES.length];
    public long blobs;
    public long nerrors;
    public static final int[] SLOT_SIZES = new int[]{64, 128, 192, 320, 512, 768, 1024, 2048, 3072, 4096, 8192};
    public long nrawRecs = 0L;
    public long rawRecBytes;

    protected void trackSlotSize(long allocationSize) {
        for (int i = 0; i < SLOT_SIZES.length; ++i) {
            if (allocationSize > (long)SLOT_SIZES[i]) continue;
            int n = i;
            this.histogram[n] = this.histogram[n] + 1L;
            return;
        }
        ++this.blobs;
    }

    public long getTotalBytes() {
        return this.nodeBytes + this.leafBytes + this.rawRecBytes;
    }

    public long getBytesPerNode() {
        return this.nnodes == 0L ? 0L : this.nodeBytes / this.nnodes;
    }

    public long getBytesPerLeaf() {
        return this.nleaves == 0L ? 0L : this.leafBytes / this.nleaves;
    }

    public long getBytesPerRawRecord() {
        return this.nrawRecs == 0L ? 0L : this.rawRecBytes / this.nrawRecs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName());
        sb.append("{indexType=" + (Object)((Object)this.indexType));
        sb.append(",m=" + this.m);
        sb.append(",nnodes=" + this.nnodes);
        sb.append(",nleaves=" + this.nleaves);
        sb.append(",nrawRecs=" + this.nrawRecs);
        sb.append(",nodeBytes=" + this.nodeBytes);
        sb.append(",minNodeBytes=" + this.minNodeBytes);
        sb.append(",maxNodeBytes=" + this.maxNodeBytes);
        sb.append(",leafBytes=" + this.leafBytes);
        sb.append(",minLeafBytes=" + this.minLeafBytes);
        sb.append(",maxLeafBytes=" + this.maxLeafBytes);
        sb.append(",rawRecBytes=" + this.rawRecBytes);
        sb.append(",bytesPerNode=" + this.getBytesPerNode());
        sb.append(",bytesPerLeaf=" + this.getBytesPerLeaf());
        sb.append(",bytesPerRawRec=" + this.getBytesPerRawRecord());
        sb.append(",nerrors=" + this.nerrors);
        long npages = this.nleaves + this.nnodes;
        for (int i = 0; i < SLOT_SIZES.length; ++i) {
            long slotsThisSize = this.histogram[i];
            double percentSlotSize = (double)slotsThisSize / (double)npages;
            sb.append(",slot_" + SLOT_SIZES[i] + "=" + PageStats.round(percentSlotSize));
        }
        double percentBlobs = (double)this.blobs / (double)npages;
        sb.append(",blobs=" + PageStats.round(percentBlobs));
        sb.append(",newM=" + this.getRecommendedBranchingFactor());
        sb.append("}");
        return sb.toString();
    }

    private static double round(double d) {
        return (double)((int)(100.0 * d)) / 100.0;
    }

    @Override
    public String getHeaderRow() {
        StringBuilder sb = new StringBuilder();
        sb.append("name");
        sb.append('\t');
        sb.append("indexType");
        sb.append('\t');
        sb.append("m");
        sb.append('\t');
        sb.append("height");
        sb.append('\t');
        sb.append("nnodes");
        sb.append('\t');
        sb.append("nleaves");
        sb.append('\t');
        sb.append("nentries");
        sb.append('\t');
        sb.append("nrawRecs");
        sb.append('\t');
        sb.append("nerrors");
        sb.append('\t');
        sb.append("nodeBytes");
        sb.append('\t');
        sb.append("leafBytes");
        sb.append('\t');
        sb.append("rawRecBytes");
        sb.append('\t');
        sb.append("totalBytes");
        sb.append('\t');
        sb.append("avgNodeBytes");
        sb.append('\t');
        sb.append("avgLeafBytes");
        sb.append('\t');
        sb.append("avgRawRecBytes");
        sb.append('\t');
        sb.append("minNodeBytes");
        sb.append('\t');
        sb.append("maxNodeBytes");
        sb.append('\t');
        sb.append("minLeafBytes");
        sb.append('\t');
        sb.append("maxLeafBytes");
        for (int i = 0; i < SLOT_SIZES.length; ++i) {
            sb.append('\t');
            sb.append(SLOT_SIZES[i]);
        }
        sb.append('\t');
        sb.append("blobs");
        sb.append('\t');
        sb.append("newM");
        sb.append('\t');
        sb.append("curM");
        return sb.toString();
    }

    @Override
    public String getDataRow() {
        PageStats stats = this;
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        sb.append('\t');
        sb.append((Object)this.indexType);
        sb.append('\t');
        sb.append(stats.m);
        sb.append('\t');
        sb.append(stats.height);
        sb.append('\t');
        sb.append(stats.nnodes);
        sb.append('\t');
        sb.append(stats.nleaves);
        sb.append('\t');
        sb.append(stats.ntuples);
        sb.append('\t');
        sb.append(stats.nrawRecs);
        sb.append('\t');
        sb.append(stats.nerrors);
        sb.append('\t');
        sb.append(stats.nodeBytes);
        sb.append('\t');
        sb.append(stats.leafBytes);
        sb.append('\t');
        sb.append(stats.rawRecBytes);
        sb.append('\t');
        sb.append(stats.getTotalBytes());
        sb.append('\t');
        sb.append(stats.getBytesPerNode());
        sb.append('\t');
        sb.append(stats.getBytesPerLeaf());
        sb.append('\t');
        sb.append(stats.getBytesPerRawRecord());
        sb.append('\t');
        sb.append(stats.minNodeBytes);
        sb.append('\t');
        sb.append(stats.maxNodeBytes);
        sb.append('\t');
        sb.append(stats.minLeafBytes);
        sb.append('\t');
        sb.append(stats.maxLeafBytes);
        long npages = stats.nleaves + stats.nnodes;
        for (int i = 0; i < SLOT_SIZES.length; ++i) {
            sb.append('\t');
            long slotsThisSize = stats.histogram[i];
            double percentSlotSize = (double)slotsThisSize / (double)npages;
            sb.append(percentSlotSize);
        }
        sb.append('\t');
        sb.append((double)stats.blobs / (double)npages);
        sb.append('\t');
        sb.append(stats.getRecommendedBranchingFactor());
        sb.append('\t');
        sb.append(stats.m);
        return sb.toString();
    }

    public abstract int getRecommendedBranchingFactor();

    public void visit(ISimpleTreeIndexAccess ndx, IAbstractNodeData node) {
        IIdentityAccess po;
        PageStats stats = this;
        if (stats.nvisited == 0L) {
            stats.name = ((ICheckpointProtocol)((Object)ndx)).getIndexMetadata().getName();
            stats.indexType = ((ICheckpointProtocol)((Object)ndx)).getCheckpoint().getIndexType();
        }
        if ((po = (IIdentityAccess)((Object)node)).isPersistent()) {
            long addrSelf = po.getIdentity();
            IRawStore store = ndx.getStore();
            long nbytes = store.getByteCount(addrSelf);
            stats.trackSlotSize(nbytes);
            boolean isLeaf = node.isLeaf();
            if (isLeaf) {
                ILeafData data;
                ++stats.nleaves;
                stats.leafBytes += nbytes;
                if (stats.minLeafBytes > nbytes || stats.minLeafBytes == 0L) {
                    stats.minLeafBytes = nbytes;
                }
                if (stats.maxLeafBytes < nbytes) {
                    stats.maxLeafBytes = nbytes;
                }
                if (node instanceof ILeafData && (data = (ILeafData)node).hasRawRecords()) {
                    for (int i = 0; i < data.getKeys().size(); ++i) {
                        long rawAddr = data.getRawRecord(i);
                        if (rawAddr == 0L) continue;
                        ++stats.nrawRecs;
                        stats.rawRecBytes += (long)store.getByteCount(rawAddr);
                    }
                }
            } else {
                ++stats.nnodes;
                stats.nodeBytes += nbytes;
                if (stats.minNodeBytes > nbytes || stats.minNodeBytes == 0L) {
                    stats.minNodeBytes = nbytes;
                }
                if (stats.maxNodeBytes < nbytes) {
                    stats.maxNodeBytes = nbytes;
                }
            }
        }
        ++stats.nvisited;
    }
}

