/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.btree.raba;

import com.bigdata.btree.raba.IRaba;
import com.bigdata.util.BytesUtil;
import java.io.DataInput;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class AbstractRaba
implements IRaba {
    protected final int fromIndex;
    protected int toIndex;
    protected final int capacity;
    protected final byte[][] a;

    public AbstractRaba(byte[][] a) {
        this(0, a.length, a.length, a);
    }

    public AbstractRaba(int fromIndex, int toIndex, int capacity, byte[][] a) {
        if (a == null) {
            throw new IllegalArgumentException();
        }
        if (fromIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        if (toIndex > a.length) {
            throw new IllegalArgumentException();
        }
        if (capacity < toIndex - fromIndex) {
            throw new IllegalArgumentException();
        }
        this.fromIndex = fromIndex;
        this.toIndex = toIndex;
        this.capacity = capacity;
        this.a = a;
    }

    @Override
    public final int size() {
        return this.toIndex - this.fromIndex;
    }

    @Override
    public final boolean isEmpty() {
        return this.toIndex == this.fromIndex;
    }

    @Override
    public final boolean isFull() {
        return this.size() == this.capacity();
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    protected final boolean rangeCheck(int index) throws IndexOutOfBoundsException {
        if (index < 0 || index >= this.toIndex - this.fromIndex) {
            throw new IndexOutOfBoundsException("index=" + index + ", fromIndex=" + this.fromIndex + ", toIndex=" + this.toIndex);
        }
        return true;
    }

    @Override
    public final byte[] get(int index) {
        assert (this.rangeCheck(index));
        return this.a[this.fromIndex + index];
    }

    @Override
    public final int length(int index) {
        assert (this.rangeCheck(index));
        byte[] tmp = this.a[this.fromIndex + index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        return tmp.length;
    }

    @Override
    public final boolean isNull(int index) {
        assert (this.rangeCheck(index));
        return this.a[this.fromIndex + index] == null;
    }

    @Override
    public final int copy(int index, OutputStream out) {
        assert (this.rangeCheck(index));
        byte[] tmp = this.a[this.fromIndex + index];
        if (tmp == null) {
            throw new NullPointerException();
        }
        try {
            out.write(tmp, 0, tmp.length);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return tmp.length;
    }

    @Override
    public final Iterator<byte[]> iterator() {
        return new Iterator<byte[]>(){
            private int i;
            {
                this.i = AbstractRaba.this.fromIndex;
            }

            @Override
            public boolean hasNext() {
                return this.i < AbstractRaba.this.toIndex;
            }

            @Override
            public byte[] next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return AbstractRaba.this.a[this.i++];
            }

            @Override
            public void remove() {
                if (AbstractRaba.this.isReadOnly()) {
                    throw new UnsupportedOperationException();
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    protected void assertNotReadOnly() {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException();
        }
    }

    protected void assertNotFull() {
        if (this.toIndex >= this.fromIndex + this.a.length) {
            throw new IllegalStateException();
        }
    }

    protected void assertNullAllowed(byte[] a) {
        if (a == null && this.isKeys()) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public void set(int index, byte[] key) {
        this.assertNotReadOnly();
        assert (this.rangeCheck(index));
        this.assertNullAllowed(key);
        this.a[this.fromIndex + index] = key;
    }

    @Override
    public int add(byte[] key) {
        this.assertNotReadOnly();
        this.assertNotFull();
        this.assertNullAllowed(key);
        assert (this.toIndex < this.fromIndex + this.capacity);
        this.a[this.toIndex++] = key;
        return this.toIndex - this.fromIndex;
    }

    @Override
    public int add(byte[] key, int off, int len) {
        this.assertNotReadOnly();
        this.assertNotFull();
        this.assertNullAllowed(key);
        byte[] b = new byte[len];
        System.arraycopy(key, off, b, 0, len);
        this.a[this.toIndex++] = b;
        return this.toIndex - this.fromIndex;
    }

    @Override
    public int add(DataInput in, int len) throws IOException {
        this.assertNotReadOnly();
        this.assertNotFull();
        byte[] b = new byte[len];
        in.readFully(b, 0, len);
        this.a[this.toIndex++] = b;
        return this.toIndex - this.fromIndex;
    }

    @Override
    public int search(byte[] searchKey) {
        if (!this.isKeys()) {
            throw new UnsupportedOperationException();
        }
        return BytesUtil.binarySearch((byte[][])this.a, (int)0, (int)this.size(), (byte[])searchKey);
    }

    public String toString() {
        return AbstractRaba.toString(this);
    }

    public static String toString(IRaba raba) {
        StringBuilder sb = new StringBuilder();
        boolean isKeys = raba.isKeys();
        sb.append(raba.getClass().getName());
        sb.append("{ capacity=" + raba.capacity());
        sb.append(", size=" + raba.size());
        sb.append(", isKeys=" + isKeys);
        sb.append(", isReadOnly=" + raba.isReadOnly());
        sb.append(", [\n");
        int i = 0;
        for (byte[] a : raba) {
            if (i > 0) {
                sb.append(",\n");
            }
            if (a == null) {
                sb.append("null");
            } else if (isKeys) {
                sb.append(BytesUtil.toString((byte[])a));
            } else {
                sb.append(Arrays.toString(a));
            }
            ++i;
        }
        sb.append("]}");
        return sb.toString();
    }

    public AbstractRaba resize(int n) {
        this.assertNotReadOnly();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        int m = this.size();
        int p = Math.min(m, n);
        byte[][] b = new byte[n][];
        System.arraycopy(this.a, this.fromIndex, b, 0, p);
        try {
            Constructor<?> ctor = this.getClass().getConstructor(byte[].class);
            return (AbstractRaba)ctor.newInstance(new Object[]{this.a});
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

