/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.concurrent;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class AccessSemaphore {
    final int maxShares;
    private final Semaphore semaphore;
    volatile Thread exclusiveOwner = null;

    public AccessSemaphore() {
        this(Integer.MAX_VALUE);
    }

    public AccessSemaphore(int maxShares) {
        this.maxShares = maxShares;
        this.semaphore = new Semaphore(maxShares, true);
    }

    public final Access acquireExclusive() throws InterruptedException {
        if (this.exclusiveOwner != null && this.exclusiveOwner == Thread.currentThread()) {
            throw new AccessSemaphoreNotReentrantException();
        }
        this.semaphore.acquire(this.maxShares);
        this.exclusiveOwner = Thread.currentThread();
        return new ExclusiveAccess();
    }

    public final Access tryAcquireExclusive(long timeout, TimeUnit unit) throws InterruptedException {
        this.semaphore.tryAcquire(this.maxShares, timeout, unit);
        return new ExclusiveAccess();
    }

    private final void releaseExclusive() {
        this.exclusiveOwner = null;
        this.semaphore.release(this.maxShares);
    }

    public final Access acquireShared() throws InterruptedException {
        this.semaphore.acquire();
        return new SharedAccess();
    }

    public final Access tryAcquireShared(long timeout, TimeUnit unit) throws InterruptedException {
        this.semaphore.tryAcquire(timeout, unit);
        return new SharedAccess();
    }

    private final void releaseShared() {
        this.semaphore.release();
    }

    public static final class AccessSemaphoreNotReentrantException
    extends IllegalStateException {
        private static final long serialVersionUID = -234560202749194378L;
    }

    public class SharedAccess
    extends Access {
        @Override
        protected void doRelease() {
            AccessSemaphore.this.releaseShared();
        }
    }

    public class ExclusiveAccess
    extends Access {
        @Override
        protected void doRelease() {
            AccessSemaphore.this.releaseExclusive();
        }
    }

    public abstract class Access {
        boolean released = false;

        public final void release() {
            if (this.released) {
                throw new IllegalStateException();
            }
            this.doRelease();
            this.released = true;
        }

        protected abstract void doRelease();
    }
}

