/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.query;

import com.bigdata.counters.CounterSet;
import com.bigdata.counters.ICounter;
import com.bigdata.counters.PeriodEnum;
import com.bigdata.counters.query.ICounterSelector;
import com.bigdata.counters.store.CounterSetBTree;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Pattern;

public class CounterSetBTreeSelector
implements ICounterSelector {
    private final CounterSetBTree btree;

    public CounterSetBTreeSelector(CounterSetBTree btree) {
        if (btree == null) {
            throw new IllegalStateException();
        }
        this.btree = btree;
    }

    @Override
    public ICounter[] selectCounters(int depth, Pattern pattern, long fromTime, long toTime, PeriodEnum period, boolean historyRequiredIsIgnored) {
        CounterSet counterSet = this.btree.rangeIterator(fromTime, toTime, period.toTimeUnit(), pattern, depth);
        Iterator<ICounter> itr = counterSet.getCounters(null);
        Vector<ICounter> v = new Vector<ICounter>();
        while (itr.hasNext()) {
            ICounter c = itr.next();
            v.add(c);
        }
        return v.toArray(new ICounter[v.size()]);
    }
}

