/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import java.io.IOException;
import java.io.Writer;

public enum DoctypeEnum {
    html_4_01_strict("-//W3C//DTD HTML 4.01//EN", "http://www.w3.org/TR/html4/strict.dtd", false),
    html_4_01_transitional("-//W3C//DTD HTML 4.01 Transitional//EN", "http://www.w3.org/TR/html4/loose.dtd", false),
    xhtml_1_0_strict("-//W3C//DTD XHTML 1.0 Strict//EN", "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", true);

    private final String publicId;
    private final String systemId;
    private final boolean xml;

    private DoctypeEnum(String publicId, String systemId, boolean xml) {
        this.publicId = publicId;
        this.systemId = systemId;
        this.xml = xml;
    }

    public String publicId() {
        return this.publicId;
    }

    public String systemId() {
        return this.systemId;
    }

    public boolean isXML() {
        return this.xml;
    }

    public void writeValid(Writer w) throws IOException {
        switch (this) {
            case html_4_01_strict: {
                this.writeValidHTML401Strict(w);
                break;
            }
            case html_4_01_transitional: {
                this.writeValidHTML401Transitional(w);
                break;
            }
            case xhtml_1_0_strict: {
                this.writeValidXHTML(w);
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.toString());
            }
        }
    }

    private void writeValidXHTML(Writer w) throws IOException {
        w.write("<p>");
        w.write("<a href=\"http://validator.w3.org/check?uri=referer\">");
        w.write("<img");
        w.write(" src=\"http://www.w3.org/Icons/valid-xhtml10\"");
        w.write(" alt=\"Valid XHTML 1.0 Strict\" height=\"31\" width=\"88\"/>");
        w.write("</a>");
        w.write("</p>");
    }

    private void writeValidHTML401Strict(Writer w) throws IOException {
        w.write("<p>");
        w.write("<a href=\"http://validator.w3.org/check?uri=referer\">");
        w.write("<img");
        w.write(" src=\"http://www.w3.org/Icons/valid-html401\"");
        w.write(" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\">");
        w.write("</a>");
        w.write("</p>");
    }

    private void writeValidHTML401Transitional(Writer w) throws IOException {
        w.write("<p>");
        w.write("<a href=\"http://validator.w3.org/check?uri=referer\">");
        w.write("<img border=\"0\"");
        w.write(" src=\"http://www.w3.org/Icons/valid-html401\"");
        w.write(" alt=\"Valid HTML 4.01 Transitional\" height=\"31\" width=\"88\">");
        w.write("</a>");
        w.write("</p>");
    }
}

