/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.counters.render;

import com.bigdata.counters.ICounter;
import com.bigdata.counters.query.HistoryTable;
import com.bigdata.counters.query.ICounterSelector;
import com.bigdata.counters.query.PivotTable;
import com.bigdata.counters.query.URLQueryModel;
import com.bigdata.counters.render.IRenderer;
import com.bigdata.counters.render.TabDelimitedHistoryTableRenderer;
import com.bigdata.counters.render.TabDelimitedPivotTableRenderer;
import com.bigdata.counters.render.TextValueFormatter;
import java.io.IOException;
import java.io.Writer;

public class TextRenderer
implements IRenderer {
    private final URLQueryModel model;
    private final ICounterSelector counterSelector;

    public TextRenderer(URLQueryModel model, ICounterSelector counterSelector) {
        if (model == null) {
            throw new IllegalArgumentException();
        }
        if (counterSelector == null) {
            throw new IllegalArgumentException();
        }
        this.model = model;
        this.counterSelector = counterSelector;
    }

    @Override
    public void render(Writer w) throws IOException {
        IRenderer renderer;
        switch (this.model.reportType) {
            case correlated: {
                ICounter[] counters = this.counterSelector.selectCounters(this.model.depth, this.model.pattern, this.model.fromTime, this.model.toTime, this.model.period, true);
                HistoryTable historyTable = new HistoryTable(counters, this.model.period);
                renderer = new TabDelimitedHistoryTableRenderer(historyTable, this.model.pattern, new TextValueFormatter(this.model));
                break;
            }
            case pivot: {
                ICounter[] counters = this.counterSelector.selectCounters(this.model.depth, this.model.pattern, this.model.fromTime, this.model.toTime, this.model.period, true);
                HistoryTable historyTable = new HistoryTable(counters, this.model.period);
                PivotTable pivotTable = new PivotTable(this.model.pattern, this.model.category, historyTable);
                renderer = new TabDelimitedPivotTableRenderer(pivotTable, new TextValueFormatter(this.model));
                break;
            }
            default: {
                throw new UnsupportedOperationException(this.model.reportType.toString());
            }
        }
        renderer.render(w);
    }
}

