/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.gom.gpo;

import com.bigdata.gom.gpo.GPO;
import com.bigdata.gom.gpo.IGPO;
import com.bigdata.gom.gpo.IGenericSkin;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class BasicSkin
implements IGenericSkin {
    protected final IGPO m_gpo;
    protected final ValueFactory m_vf;

    public BasicSkin(IGPO gpo) {
        this.m_gpo = gpo;
        this.m_vf = gpo.getObjectManager().getValueFactory();
    }

    public void rollback() {
        ((GPO)this.m_gpo).setMaterialized(false);
    }

    public void setValue(URI property, Value value) {
        this.m_gpo.setValue(property, value);
    }

    public void setValue(URI property, String value) {
        this.m_gpo.setValue(property, (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(URI property, int value) {
        this.m_gpo.setValue(property, (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(URI property, double value) {
        this.m_gpo.setValue(property, (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(URI property, XMLGregorianCalendar value) {
        this.m_gpo.setValue(property, (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(String property, Value value) {
        this.m_gpo.setValue(this.m_vf.createURI(property), value);
    }

    public void setValue(String property, String value) {
        this.m_gpo.setValue(this.m_vf.createURI(property), (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(String property, int value) {
        this.m_gpo.setValue(this.m_vf.createURI(property), (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(String property, double value) {
        this.m_gpo.setValue(this.m_vf.createURI(property), (Value)this.m_vf.createLiteral(value));
    }

    public void setValue(String property, XMLGregorianCalendar value) {
        this.m_gpo.setValue(this.m_vf.createURI(property), (Value)this.m_vf.createLiteral(value));
    }

    @Override
    public IGPO asGeneric() {
        return this.m_gpo;
    }

    public int getIntValue(URI key) {
        Value v = this.m_gpo.getValue(key);
        if (v instanceof Literal) {
            return ((Literal)v).intValue();
        }
        return 0;
    }

    public double getDoubleValue(URI key) {
        Value v = this.m_gpo.getValue(key);
        if (v instanceof Literal) {
            return ((Literal)v).doubleValue();
        }
        return 0.0;
    }

    public boolean getBooleanValue(URI key) {
        Value v = this.m_gpo.getValue(key);
        if (v instanceof Literal) {
            return ((Literal)v).booleanValue();
        }
        return false;
    }

    public String getStringValue(URI key) {
        Value v = this.m_gpo.getValue(key);
        if (v instanceof Literal) {
            return ((Literal)v).stringValue();
        }
        return null;
    }

    public IGPO getGPOValue(URI key) {
        Value v = this.m_gpo.getValue(key);
        if (v instanceof Resource) {
            return this.m_gpo.getObjectManager().getGPO((Resource)v);
        }
        return null;
    }

    public int getInt(String key) {
        return this.getIntValue(this.m_vf.createURI(key));
    }

    public double getDouble(String key) {
        return this.getDoubleValue(this.m_vf.createURI(key));
    }

    public boolean getBoolean(String key) {
        return this.getBooleanValue(this.m_vf.createURI(key));
    }

    public String getString(String key) {
        return this.getStringValue(this.m_vf.createURI(key));
    }
}

