/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha;

import com.bigdata.ha.CommitRequest;
import com.bigdata.util.concurrent.ExecutionExceptions;
import java.util.ArrayList;

public class CommitResponse {
    private final CommitRequest req;
    private final ArrayList<Throwable> causes;
    private final int nok;
    private final int nfail;

    public CommitResponse(CommitRequest req, ArrayList<Throwable> causes) {
        this.req = req;
        this.causes = causes;
        int nok = 0;
        int nfail = 0;
        for (Throwable t : causes) {
            if (t == null) {
                ++nok;
                continue;
            }
            ++nfail;
        }
        this.nok = nok;
        this.nfail = nfail;
    }

    public boolean isLeaderOk() {
        return this.causes.get(0) == null;
    }

    public int getNOk() {
        return this.nok;
    }

    public int getNFail() {
        return this.nfail;
    }

    public Throwable getCause(int i) {
        return this.causes.get(i);
    }

    public void throwCauses() throws Exception {
        if (this.causes.isEmpty()) {
            throw new IllegalStateException();
        }
        if (this.causes.size() == 1) {
            throw new Exception(this.causes.get(0));
        }
        int k = this.req.getPrepareResponse().replicationFactor();
        throw new Exception("replicationFactor=" + k + ", nok=" + this.nok + ", nfail=" + this.nfail, new ExecutionExceptions(this.causes));
    }
}

