/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ha.althalog;

import com.bigdata.ha.althalog.HALogFile;
import com.bigdata.ha.althalog.IHALogReader;
import com.bigdata.ha.msg.IHAWriteMessage;
import com.bigdata.io.DirectBufferPool;
import com.bigdata.io.IBufferAccess;
import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.StoreTypeEnum;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class HALogManager {
    private static final Logger haLog = Logger.getLogger((String)"com.bigdata.haLog");
    private final File m_halogdir;
    private final Lock m_currentLock = new ReentrantLock();
    private HALogFile m_current = null;
    private IHALogManagerCallback m_callback = new IHALogManagerCallback(){

        @Override
        public void release(HALogFile logfile) {
            HALogManager.this.closeLog(logfile);
        }

        @Override
        public File getHALogDir() {
            return HALogManager.this.getHALogDir();
        }
    };

    public HALogManager(File halogdir) {
        this.m_halogdir = halogdir;
        if (!this.m_halogdir.exists()) {
            throw new IllegalArgumentException();
        }
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)"HALogManager initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HALogFile createLog(IRootBlockView rbv) throws IOException {
        if (haLog.isInfoEnabled()) {
            haLog.info((Object)("Creating log for commit " + rbv.getCommitCounter()));
        }
        this.m_currentLock.lock();
        try {
            HALogFile ret;
            if (this.m_current != null) {
                throw new IllegalStateException();
            }
            this.m_current = ret = new HALogFile(rbv, this.m_callback);
            HALogFile hALogFile = ret;
            return hALogFile;
        }
        finally {
            this.m_currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLog(HALogFile current) {
        this.m_currentLock.lock();
        try {
            if (this.m_current != current) {
                throw new IllegalStateException();
            }
            this.m_current = null;
        }
        finally {
            this.m_currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HALogFile getOpenLogFile() {
        this.m_currentLock.lock();
        try {
            HALogFile hALogFile = this.m_current;
            return hALogFile;
        }
        finally {
            this.m_currentLock.unlock();
        }
    }

    public File getCurrentFile() {
        HALogFile file = this.getOpenLogFile();
        return file == null ? null : file.getFile();
    }

    public File getHALogDir() {
        return this.m_halogdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IHALogReader getReader(long commitCounter) throws IOException {
        this.m_currentLock.lock();
        try {
            if (this.m_current != null && this.m_current.getCommitCounter() == commitCounter) {
                IHALogReader iHALogReader = this.m_current.getReader();
                return iHALogReader;
            }
        }
        finally {
            this.m_currentLock.unlock();
        }
        File file = HALogFile.getHALogFileName(this.m_halogdir, commitCounter);
        HALogFile halog = new HALogFile(file);
        return halog.getReader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HALogFile getHALogFile(long commitCounter) throws FileNotFoundException {
        File file = HALogFile.getHALogFileName(this.m_halogdir, commitCounter);
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        this.m_currentLock.lock();
        try {
            if (this.m_current != null && this.m_current.getCommitCounter() == commitCounter) {
                HALogFile hALogFile = this.m_current;
                return hALogFile;
            }
        }
        finally {
            this.m_currentLock.unlock();
        }
        return new HALogFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() throws IOException {
        this.m_currentLock.lock();
        try {
            if (this.m_current != null) {
                this.m_current.disable();
            }
            this.m_current = null;
        }
        finally {
            this.m_currentLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        IBufferAccess buf = DirectBufferPool.INSTANCE.acquire();
        try {
            for (String arg : args) {
                File file = new File(arg);
                if (!file.exists()) {
                    System.err.println("No such file: " + file);
                    continue;
                }
                if (file.isDirectory()) {
                    HALogManager.doDirectory(file, buf);
                    continue;
                }
                HALogManager.doFile(file, buf);
            }
        }
        finally {
            buf.release();
        }
    }

    private static File[] logFiles(File dir) {
        return dir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return true;
                }
                return name.endsWith(".ha-log");
            }
        });
    }

    private static void doDirectory(File dir, IBufferAccess buf) throws IOException {
        File[] files;
        for (File file : files = HALogManager.logFiles(dir)) {
            if (file.isDirectory()) {
                HALogManager.doDirectory(file, buf);
                continue;
            }
            HALogManager.doFile(file, buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doFile(File file, IBufferAccess buf) throws IOException {
        HALogFile f = new HALogFile(file);
        try (IHALogReader r = f.getReader();){
            boolean isWORM;
            IRootBlockView openingRootBlock = r.getOpeningRootBlock();
            IRootBlockView closingRootBlock = r.getClosingRootBlock();
            boolean bl = isWORM = openingRootBlock.getStoreType() == StoreTypeEnum.WORM;
            if (openingRootBlock.getCommitCounter() == closingRootBlock.getCommitCounter()) {
                System.err.println("EMPTY LOG: " + file);
            }
            System.out.println("----------begin----------");
            System.out.println("file=" + file);
            System.out.println("openingRootBlock=" + openingRootBlock);
            System.out.println("closingRootBlock=" + closingRootBlock);
            while (r.hasMoreBuffers()) {
                IHAWriteMessage msg = r.processNextBuffer(isWORM ? null : buf.buffer());
                System.out.println(msg.toString());
            }
            System.out.println("-----------end-----------");
        }
    }

    static interface IHALogManagerCallback {
        public File getHALogDir();

        public void release(HALogFile var1);
    }
}

