/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.io;

import com.bigdata.journal.Options;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;
import org.apache.log4j.Logger;

public class FileLockUtility {
    protected static final Logger log = Logger.getLogger(FileLockUtility.class);
    protected static final boolean INFO = log.isInfoEnabled();
    protected static final boolean DEBUG = log.isDebugEnabled();
    static String pid = UUID.randomUUID().toString();

    public static RandomAccessFile openFile(File file, String fileMode, boolean useFileLock) throws IOException {
        boolean readOnly = "r".equals(fileMode);
        RandomAccessFile raf = new RandomAccessFile(file, fileMode);
        if (readOnly) {
            return raf;
        }
        boolean fileLockEnabled = Boolean.parseBoolean(System.getProperty(Options.FILE_LOCK_ENABLED, "true"));
        if (useFileLock && fileLockEnabled) {
            if (INFO) {
                log.info((Object)("Seeking exclusive lock: " + file.getAbsolutePath()));
            }
            if (new File(file + ".lock").exists()) {
                raf.close();
                throw new IOException("Advisory lock exists: " + file.getAbsolutePath());
            }
            try {
                if (raf.getChannel().tryLock() != null) {
                    return raf;
                }
                try {
                    raf.close();
                }
                catch (Throwable t) {
                    log.error((Object)t, t);
                }
                throw new RuntimeException("Already locked: " + file.getAbsoluteFile());
            }
            catch (IOException ex) {
                log.warn((Object)("FileLock not supported: file=" + file.getAbsolutePath() + " : " + ex));
                return FileLockUtility._acquireAdvisoryLock(raf, file);
            }
        }
        return FileLockUtility._acquireAdvisoryLock(raf, file);
    }

    private static RandomAccessFile _acquireAdvisoryLock(RandomAccessFile raf, File file) throws IOException {
        try {
            if (FileLockUtility.acquireAdvisoryLock(file)) {
                return raf;
            }
            try {
                raf.close();
            }
            catch (IOException t) {
                log.error((Object)t, (Throwable)t);
            }
            throw new IOException("Advisory lock exists: " + file.getAbsolutePath());
        }
        catch (IOException ex2) {
            log.error((Object)("Error while seeking advisory lock: file=" + file.getAbsolutePath()), (Throwable)ex2);
            try {
                raf.close();
            }
            catch (IOException t) {
                log.error((Object)t, (Throwable)t);
            }
            throw ex2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeFile(File file, RandomAccessFile raf) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        if (raf == null) {
            throw new IllegalArgumentException();
        }
        try {
            if (raf.getChannel().isOpen()) {
                raf.close();
            }
        }
        finally {
            FileLockUtility.removeAdvisoryLock(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean acquireAdvisoryLock(File file) throws IOException {
        File lockFile;
        if (INFO) {
            log.info((Object)("Seeking advisory lock: " + file.getAbsolutePath()));
        }
        if ((lockFile = new File(file + ".lock")).exists()) {
            return FileLockUtility.isOurLockFile(lockFile);
        }
        if (!lockFile.createNewFile()) {
            return false;
        }
        try (BufferedWriter w = new BufferedWriter(new FileWriter(lockFile));){
            w.write(pid);
            w.write(10);
            w.flush();
        }
        if (INFO) {
            log.info((Object)("Created advisory lock: " + file.getAbsolutePath()));
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isOurLockFile(File lockFile) throws IOException {
        try (BufferedReader r = new BufferedReader(new FileReader(lockFile));){
            String str = r.readLine();
            if (pid.equals(str)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    public static synchronized void removeAdvisoryLock(File file) throws IOException {
        File lockFile = new File(file + ".lock");
        if (!lockFile.exists()) {
            return;
        }
        if (!FileLockUtility.isOurLockFile(lockFile)) {
            throw new IOException("Not our lock file: " + lockFile.getAbsolutePath());
        }
        if (!lockFile.delete()) {
            throw new IOException("Could not delete lock file: " + lockFile.getAbsolutePath());
        }
    }
}

