/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.IRootBlockView;
import com.bigdata.journal.ISnapshotFactory;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;

public class BasicSnapshotFactory
implements ISnapshotFactory {
    private static final Logger log = Logger.getLogger(BasicSnapshotFactory.class);
    private static final boolean debug = log.isDebugEnabled();
    private static final boolean info = log.isDebugEnabled();
    private String file = "backup.jnl";
    private boolean compress = false;

    public BasicSnapshotFactory(String file, boolean compress) {
        this.file = file;
        this.compress = compress;
    }

    public BasicSnapshotFactory() {
        this.file = this.getAbsolutePath(this.file);
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = this.getAbsolutePath(file);
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    protected String getAbsolutePath(String file) {
        String ret = file;
        File f = new File(file);
        if (f.getParent() == null) {
            ret = f.getAbsolutePath();
        }
        f = null;
        return ret;
    }

    @Override
    public File getSnapshotFile(IRootBlockView rbv) throws IOException {
        File f = new File(this.file);
        if (!f.createNewFile()) {
            if (debug) {
                log.debug((Object)("Backup file " + this.file + " already exists."));
            }
            throw new RuntimeException("Backup file " + this.file + " already exists.");
        }
        if (!f.canWrite()) {
            if (debug) {
                log.debug((Object)("Backup file " + this.file + " is not writable."));
            }
            throw new RuntimeException("Backup file " + this.file + " is not writable.");
        }
        return f;
    }

    @Override
    public boolean getCompress() {
        return this.compress;
    }
}

