/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.StoreTypeEnum;

public enum BufferMode {
    Transient(false, true, Integer.MAX_VALUE, StoreTypeEnum.WORM),
    Direct(true, true, Integer.MAX_VALUE, StoreTypeEnum.WORM),
    Mapped(true, false, Long.MAX_VALUE, StoreTypeEnum.WORM),
    Disk(true, false, Long.MAX_VALUE, StoreTypeEnum.WORM),
    DiskWORM(true, false, Long.MAX_VALUE, StoreTypeEnum.WORM),
    DiskRW(true, false, 0x40000000000L, StoreTypeEnum.RW),
    TemporaryRW(false, false, 0x40000000000L, StoreTypeEnum.RW),
    Temporary(false, false, Long.MAX_VALUE, StoreTypeEnum.WORM),
    MemStore(false, true, 0x40000000000L, StoreTypeEnum.RW);

    private final boolean stable;
    private final boolean fullyBuffered;
    private final long maxExtent;
    private final StoreTypeEnum storeType;

    private BufferMode(boolean stable, boolean fullyBuffered, long maxExtent, StoreTypeEnum storeType) {
        this.stable = stable;
        this.fullyBuffered = fullyBuffered;
        this.maxExtent = maxExtent;
        this.storeType = storeType;
    }

    public boolean isStable() {
        return this.stable;
    }

    public boolean isFullyBuffered() {
        return this.fullyBuffered;
    }

    public long getMaxExtent() {
        return this.maxExtent;
    }

    public StoreTypeEnum getStoreType() {
        return this.storeType;
    }

    public static BufferMode getDefaultBufferMode(StoreTypeEnum storeType) {
        switch (storeType) {
            case RW: {
                return DiskRW;
            }
        }
        return DiskWORM;
    }
}

