/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.counters.AbstractStatisticsCollector;
import com.bigdata.counters.ganglia.BigdataGangliaService;
import com.bigdata.counters.ganglia.BigdataMetadataFactory;
import com.bigdata.counters.ganglia.HostMetricsCollector;
import com.bigdata.counters.ganglia.QueryEngineMetricsCollector;
import com.bigdata.ganglia.DefaultMetadataFactory;
import com.bigdata.ganglia.GangliaMetadataFactory;
import com.bigdata.ganglia.GangliaService;
import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaDefaults;
import com.bigdata.ganglia.IGangliaMetadataFactory;
import com.bigdata.ganglia.util.GangliaUtil;
import com.bigdata.journal.IPlugIn;
import com.bigdata.journal.Journal;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Properties;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public class GangliaPlugIn
implements IPlugIn<Journal, GangliaService> {
    private static final Logger log = Logger.getLogger(GangliaPlugIn.class);
    private final AtomicReference<FutureTask<Void>> gangliaFuture = new AtomicReference();
    private final AtomicReference<BigdataGangliaService> gangliaService = new AtomicReference();

    @Override
    public void startService(Journal journal) {
        AbstractStatisticsCollector statisticsCollector = journal.getPlatformStatisticsCollector();
        if (statisticsCollector == null) {
            return;
        }
        Properties properties = journal.getProperties();
        boolean listen = Boolean.valueOf(properties.getProperty(Options.GANGLIA_LISTEN, "false"));
        boolean report = Boolean.valueOf(properties.getProperty(Options.GANGLIA_REPORT, "false"));
        if (!listen && !report) {
            return;
        }
        try {
            String hostName = AbstractStatisticsCollector.fullyQualifiedHostName;
            String serviceName = statisticsCollector.getProcessName();
            InetAddress listenGroup = InetAddress.getByName(properties.getProperty(Options.GANGLIA_LISTEN_GROUP, "239.2.11.71"));
            int listenPort = Integer.valueOf(properties.getProperty(Options.GANGLIA_LISTEN_PORT, Options.DEFAULT_GANGLIA_LISTEN_PORT));
            InetSocketAddress[] metricsServers = GangliaUtil.parse((String)properties.getProperty(Options.GANGLIA_SERVERS, "239.2.11.71"), (String)listenGroup.getHostName(), (int)listenPort);
            int quietPeriod = 600;
            int initialDelay = 20;
            boolean heartbeatInterval = false;
            int monitoringInterval = (int)TimeUnit.MILLISECONDS.toSeconds(Long.parseLong(properties.getProperty(Options.REPORT_DELAY, "60000")));
            String defaultUnits = "";
            GangliaSlopeEnum defaultSlope = IGangliaDefaults.DEFAULT_SLOPE;
            int defaultTMax = 180;
            int defaultDMax = 3600;
            GangliaMetadataFactory metadataFactory = new GangliaMetadataFactory(new DefaultMetadataFactory("", defaultSlope, 180, 3600));
            metadataFactory.add((IGangliaMetadataFactory)new BigdataMetadataFactory(hostName, serviceName, defaultSlope, 180, 3600, 0));
            BigdataGangliaService gangliaService = new BigdataGangliaService(hostName, serviceName, metricsServers, listenGroup, listenPort, listen, report, false, 600, 20, 0, monitoringInterval, 3600, (IGangliaMetadataFactory)metadataFactory);
            gangliaService.addMetricCollector(new HostMetricsCollector(statisticsCollector));
            gangliaService.addMetricCollector(new QueryEngineMetricsCollector(journal, statisticsCollector));
            FutureTask<Void> ft = new FutureTask<Void>((Runnable)((Object)gangliaService), null);
            this.gangliaFuture.set(ft);
            this.gangliaService.set(gangliaService);
            journal.getExecutorService().submit(ft);
        }
        catch (RejectedExecutionException t) {
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
    }

    @Override
    public void stopService(boolean immediateShutdown) {
        FutureTask ft = this.gangliaFuture.getAndSet(null);
        if (ft != null) {
            ft.cancel(immediateShutdown);
        }
        this.gangliaService.set(null);
    }

    @Override
    public boolean isRunning() {
        FutureTask<Void> ft = this.gangliaFuture.get();
        return ft != null && !ft.isDone();
    }

    @Override
    public GangliaService getService() {
        return this.gangliaService.get();
    }

    public static interface Options {
        public static final String GANGLIA_LISTEN_GROUP = Journal.class.getName() + ".ganglia.listenGroup";
        public static final String DEFAULT_GANGLIA_LISTEN_GROUP = "239.2.11.71";
        public static final String GANGLIA_LISTEN_PORT = Journal.class.getName() + ".ganglia.listenPort";
        public static final String DEFAULT_GANGLIA_LISTEN_PORT = Integer.toString(8649);
        public static final String GANGLIA_LISTEN = Journal.class.getName() + ".ganglia.listen";
        public static final String DEFAULT_GANGLIA_LISTEN = "false";
        public static final String GANGLIA_REPORT = Journal.class.getName() + ".ganglia.report";
        public static final String DEFAULT_GANGLIA_REPORT = "false";
        public static final String GANGLIA_SERVERS = Journal.class.getName() + ".ganglia.servers";
        public static final String DEFAULT_GANGLIA_SERVERS = "239.2.11.71";
        public static final String REPORT_DELAY = Journal.class.getName() + ".reportDelay";
        public static final String DEFAULT_REPORT_DELAY = "60000";
    }
}

