/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.journal;

import com.bigdata.journal.IPlugIn;
import com.bigdata.journal.Journal;
import com.bigdata.util.concurrent.ThreadPoolExecutorBaseStatisticsTask;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class QueueStatsPlugIn
implements IPlugIn<Journal, ThreadPoolExecutorBaseStatisticsTask> {
    private static final Logger log = Logger.getLogger(QueueStatsPlugIn.class);
    private ThreadPoolExecutorBaseStatisticsTask queueSampleTask = null;
    private ScheduledFuture<?> scheduledFuture = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startService(Journal indexManager) {
        boolean collectQueueStatistics = Boolean.valueOf(indexManager.getProperty(Options.COLLECT_QUEUE_STATISTICS, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(Options.COLLECT_QUEUE_STATISTICS + "=" + collectQueueStatistics));
        }
        if (!collectQueueStatistics) {
            return;
        }
        long initialDelay = 0L;
        long delay = 1000L;
        TimeUnit unit = TimeUnit.MILLISECONDS;
        QueueStatsPlugIn queueStatsPlugIn = this;
        synchronized (queueStatsPlugIn) {
            this.queueSampleTask = new ThreadPoolExecutorBaseStatisticsTask((ThreadPoolExecutor)indexManager.getExecutorService());
            this.scheduledFuture = indexManager.addScheduledTask(this.queueSampleTask, 0L, 1000L, unit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopService(boolean immediateShutdown) {
        QueueStatsPlugIn queueStatsPlugIn = this;
        synchronized (queueStatsPlugIn) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(immediateShutdown);
                this.scheduledFuture = null;
            }
            this.queueSampleTask = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ThreadPoolExecutorBaseStatisticsTask getService() {
        QueueStatsPlugIn queueStatsPlugIn = this;
        synchronized (queueStatsPlugIn) {
            return this.queueSampleTask;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning() {
        QueueStatsPlugIn queueStatsPlugIn = this;
        synchronized (queueStatsPlugIn) {
            return this.scheduledFuture != null && !this.scheduledFuture.isDone();
            {
            }
        }
    }

    public static interface Options {
        public static final String COLLECT_QUEUE_STATISTICS = Journal.class.getName() + ".collectQueueStatistics";
        public static final String DEFAULT_COLLECT_QUEUE_STATISTICS = "false";
    }
}

