/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.mdi;

import com.bigdata.io.ShortPacker;
import com.bigdata.mdi.IResourceMetadata;
import com.bigdata.mdi.SegmentMetadata;
import com.bigdata.service.Params;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;

public abstract class AbstractResourceMetadata
implements IResourceMetadata,
Externalizable,
Params {
    protected static final Logger log = Logger.getLogger(AbstractResourceMetadata.class);
    private String filename;
    private UUID uuid;
    private long createTime;
    private long commitTime;
    private static final transient short VERSION0 = 0;
    private static final transient short VERSION1 = 1;

    @Override
    public Map<String, Object> getParams() {
        HashMap<String, Object> v = new HashMap<String, Object>();
        v.put("UUID", this.uuid);
        v.put("filename", this.filename);
        v.put("createTime", this.createTime);
        return v;
    }

    public AbstractResourceMetadata() {
    }

    protected AbstractResourceMetadata(String filename, UUID uuid, long createTime, long commitTime) {
        if (filename == null || uuid == null) {
            throw new IllegalArgumentException();
        }
        this.filename = filename;
        this.uuid = uuid;
        this.createTime = createTime;
        if (createTime == 0L) {
            throw new IllegalArgumentException("Create time is zero? : " + this);
        }
        this.commitTime = commitTime;
    }

    @Override
    public final int hashCode() {
        return this.uuid.hashCode();
    }

    public final boolean equals(Object o) {
        return this.equals((IResourceMetadata)o);
    }

    @Override
    public final boolean equals(IResourceMetadata o) {
        if (this == o) {
            return true;
        }
        return this.uuid.equals(o.getUUID()) && this.filename.equals(o.getFile()) && this.createTime == o.getCreateTime();
    }

    @Override
    public final String getFile() {
        return this.filename;
    }

    @Override
    public final UUID getUUID() {
        return this.uuid;
    }

    @Override
    public final long getCreateTime() {
        return this.createTime;
    }

    @Override
    public final long getCommitTime() {
        return this.commitTime;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        short version = ShortPacker.unpackShort(in);
        switch (version) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IOException("Unknown version: " + version);
            }
        }
        this.uuid = new UUID(in.readLong(), in.readLong());
        this.createTime = in.readLong();
        this.commitTime = version >= 1 ? in.readLong() : (this instanceof SegmentMetadata ? this.createTime : 0L);
        this.filename = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ShortPacker.packShort(out, (short)1);
        out.writeLong(this.uuid.getMostSignificantBits());
        out.writeLong(this.uuid.getLeastSignificantBits());
        out.writeLong(this.createTime);
        out.writeLong(this.commitTime);
        out.writeUTF(this.filename);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{filename=" + this.getFile() + ",uuid=" + this.getUUID() + ",createTime=" + this.getCreateTime() + ",commitTime=" + this.getCommitTime() + "}";
    }
}

