/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.rdf.internal.IDatatypeURIResolver;
import com.bigdata.rdf.internal.IExtension;
import com.bigdata.rdf.internal.IExtensionFactory;
import com.bigdata.rdf.internal.ILexiconConfiguration;
import com.bigdata.rdf.internal.impl.extensions.DateTimeExtension;
import com.bigdata.rdf.internal.impl.extensions.DerivedNumericsExtension;
import com.bigdata.rdf.internal.impl.extensions.GeoSpatialLiteralExtension;
import com.bigdata.rdf.internal.impl.extensions.XSDStringExtension;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.service.geospatial.GeoSpatialDatatypeConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultExtensionFactory
implements IExtensionFactory {
    private final List<IExtension<? extends BigdataValue>> extensions = new LinkedList<IExtension<? extends BigdataValue>>();

    @Override
    public void init(IDatatypeURIResolver resolver, ILexiconConfiguration<BigdataValue> config) {
        this.extensions.add(new DerivedNumericsExtension(resolver));
        if (config.isGeoSpatial()) {
            List<GeoSpatialDatatypeConfiguration> datatypeConfigs = config.getGeoSpatialConfig().getDatatypeConfigs();
            for (int i = 0; i < datatypeConfigs.size(); ++i) {
                this.extensions.add(new GeoSpatialLiteralExtension(resolver, datatypeConfigs.get(i)));
            }
        }
        if (config.isInlineDateTimes()) {
            this.extensions.add(new DateTimeExtension(resolver, config.getInlineDateTimesTimeZone()));
        }
        if (config.getMaxInlineStringLength() > 0) {
            this.extensions.add(new XSDStringExtension(resolver, config.getMaxInlineStringLength()));
        }
        this._init(resolver, config, this.extensions);
    }

    protected void _init(IDatatypeURIResolver resolver, ILexiconConfiguration<BigdataValue> config, Collection<IExtension<? extends BigdataValue>> extensions) {
    }

    @Override
    public Iterator<IExtension<? extends BigdataValue>> getExtensions() {
        return Collections.unmodifiableList(this.extensions).iterator();
    }
}

