/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal;

import com.bigdata.util.BytesUtil;
import java.io.Serializable;
import java.util.Arrays;

public class IPv4Address
implements Serializable,
Comparable<IPv4Address> {
    private static final long serialVersionUID = 8707927477744805951L;
    private final byte[] address;

    public IPv4Address(byte[] address) {
        this.address = address;
    }

    public IPv4Address(IPv4Address ip) {
        this.address = ip.getBytes();
    }

    public byte[] getBytes() {
        return this.address;
    }

    public int hashCode() {
        return Arrays.hashCode(this.address);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv4Address other = (IPv4Address)obj;
        return BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(this.address, other.address) == 0;
    }

    public String toString() {
        return IPv4Address.byteArrayToIPString(this.address);
    }

    public static String byteArrayToIPString(byte[] addr) {
        int netmask = addr[4] & 0xFF;
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF) + (netmask <= 32 ? "/" + netmask : "");
    }

    public static IPv4Address IPv4Factory(String ... s) {
        byte[] address = new byte[5];
        if (s.length == 4) {
            for (int i = 0; i < 4; ++i) {
                long longVal = Integer.parseInt(s[i]);
                if (longVal < 0L || longVal > 255L) {
                    return null;
                }
                address[i] = (byte)(longVal & 0xFFL);
            }
            address[4] = 33;
        } else if (s.length == 5) {
            for (int i = 0; i < 5; ++i) {
                long longVal = Integer.parseInt(s[i]);
                if (longVal < 0L || longVal > 255L) {
                    return null;
                }
                if (i == 4 && longVal > 32L) {
                    return null;
                }
                address[i] = (byte)(longVal & 0xFFL);
            }
        } else {
            return null;
        }
        return new IPv4Address(address);
    }

    @Override
    public int compareTo(IPv4Address other) {
        return BytesUtil.UnsignedByteArrayComparator.INSTANCE.compare(this.address, other.address);
    }
}

