/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.constraints;

import com.bigdata.bop.BOp;
import com.bigdata.bop.IBindingSet;
import com.bigdata.bop.IValueExpression;
import com.bigdata.bop.NV;
import com.bigdata.rdf.error.SparqlTypeErrorException;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.XSD;
import com.bigdata.rdf.internal.constraints.INeedsMaterialization;
import com.bigdata.rdf.internal.constraints.IVValueExpression;
import com.bigdata.rdf.model.BigdataLiteral;
import com.bigdata.rdf.sparql.ast.GlobalAnnotations;
import java.security.MessageDigest;
import java.util.Map;
import org.openrdf.model.Literal;

public class DigestBOp
extends IVValueExpression<IV>
implements INeedsMaterialization {
    private static final long serialVersionUID = 9136864442064392445L;
    private static final char[] hexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public DigestBOp(IValueExpression<? extends IV> left, DigestOp op, GlobalAnnotations globals) {
        this(new BOp[]{left}, DigestBOp.anns(globals, new NV(Annotations.OP, (Object)op)));
    }

    public DigestBOp(BOp[] args, Map<String, Object> anns) {
        super(args, anns);
        if (args.length != 1 || args[0] == null || this.getProperty(Annotations.OP) == null) {
            throw new IllegalArgumentException();
        }
    }

    public DigestBOp(DigestBOp op) {
        super(op);
    }

    public static String toHexString(byte[] buf) {
        StringBuilder strBuf = new StringBuilder(buf.length * 2);
        for (int i = 0; i < buf.length; ++i) {
            strBuf.append(hexChar[(buf[i] & 0xF0) >>> 4]);
            strBuf.append(hexChar[buf[i] & 0xF]);
        }
        return strBuf.toString();
    }

    @Override
    public INeedsMaterialization.Requirement getRequirement() {
        return INeedsMaterialization.Requirement.SOMETIMES;
    }

    public IV get(IBindingSet bs) throws SparqlTypeErrorException {
        IV iv = this.getAndCheckLiteral(0, bs);
        MessageDigest md = null;
        Literal lit = DigestBOp.asLiteral(iv);
        if (lit.getLanguage() == null && (lit.getDatatype() == null || lit.getDatatype().equals((Object)XSD.STRING))) {
            try {
                String label = lit.getLabel();
                switch (this.op()) {
                    case MD5: {
                        md = MessageDigest.getInstance("MD5");
                        break;
                    }
                    case SHA1: {
                        md = MessageDigest.getInstance("SHA-1");
                        break;
                    }
                    case SHA224: {
                        md = MessageDigest.getInstance("SHA-224");
                        break;
                    }
                    case SHA256: {
                        md = MessageDigest.getInstance("SHA-256");
                        break;
                    }
                    case SHA384: {
                        md = MessageDigest.getInstance("SHA-384");
                        break;
                    }
                    case SHA512: {
                        md = MessageDigest.getInstance("SHA-512");
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                byte[] bytes = label.getBytes("UTF-8");
                md.update(bytes);
                byte[] digest = md.digest();
                BigdataLiteral str = this.getValueFactory().createLiteral(DigestBOp.toHexString(digest));
                return super.asIV(str, bs);
            }
            catch (Exception e) {
                throw new SparqlTypeErrorException();
            }
        }
        throw new SparqlTypeErrorException();
    }

    public DigestOp op() {
        return (DigestOp)((Object)this.getRequiredProperty(Annotations.OP));
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.op());
        sb.append("(").append(this.get(0)).append(")");
        return sb.toString();
    }

    public static enum DigestOp {
        MD5,
        SHA1,
        SHA224,
        SHA256,
        SHA384,
        SHA512;

    }

    public static interface Annotations
    extends IVValueExpression.Annotations {
        public static final String OP = DigestBOp.class.getName() + ".op";
    }
}

