/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.internal.impl.uri;

import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.rdf.internal.DTE;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.internal.VTE;
import com.bigdata.rdf.internal.impl.AbstractInlineIV;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.model.BigdataURI;
import com.bigdata.rdf.model.BigdataValueFactory;
import org.openrdf.model.URI;

public class VocabURIByteIV<V extends BigdataURI>
extends AbstractInlineIV<V, Byte>
implements URI {
    private static final long serialVersionUID = -1609505688748169776L;
    private final byte value;

    public byte byteValue() {
        return this.value;
    }

    @Override
    public IV<V, Byte> clone(boolean clearCache) {
        return this;
    }

    public VocabURIByteIV(byte value) {
        super(VTE.URI, DTE.XSDByte);
        this.value = value;
    }

    @Override
    public final boolean isVocabulary() {
        return true;
    }

    @Override
    public int _compareTo(IV o) {
        byte v2;
        byte v = KeyBuilder.decodeByte(this.value);
        return v == (v2 = KeyBuilder.decodeByte(((VocabURIByteIV)o).value)) ? 0 : (v < v2 ? -1 : 1);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof VocabURIByteIV) {
            return this.value == ((VocabURIByteIV)o).value;
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.value;
    }

    @Override
    public V asValue(LexiconRelation lex) throws UnsupportedOperationException {
        BigdataURI v = (BigdataURI)this.getValueCache();
        if (v == null) {
            BigdataValueFactory f = lex.getValueFactory();
            v = (BigdataURI)lex.getContainer().getVocabulary().asValue(this);
            v.setIV(this);
            this.setValue(v);
        }
        return (V)v;
    }

    @Override
    public final int byteLength() {
        return 2;
    }

    @Override
    public final Byte getInlineValue() {
        return this.value;
    }

    public String toString() {
        return "Vocab(" + Byte.toString(this.value) + ")" + (this.hasValue() ? "[" + ((BigdataURI)this.getValue()).stringValue() + "]" : "");
    }

    @Override
    public boolean needsMaterialization() {
        return true;
    }

    public String stringValue() {
        return ((BigdataURI)this.getValue()).stringValue();
    }

    public String getLocalName() {
        return ((BigdataURI)this.getValue()).getLocalName();
    }

    public String getNamespace() {
        return ((BigdataURI)this.getValue()).getNamespace();
    }
}

