/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.lexicon;

import com.bigdata.btree.DefaultTupleSerializer;
import com.bigdata.btree.IndexMetadata;
import com.bigdata.btree.IndexTypeEnum;
import com.bigdata.btree.keys.DefaultKeyBuilderFactory;
import com.bigdata.btree.keys.KeyBuilder;
import com.bigdata.btree.raba.codec.SimpleRabaCoder;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.TimestampUtility;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.lexicon.IValueCentricTextIndexer;
import com.bigdata.rdf.lexicon.LexiconRelation;
import com.bigdata.rdf.lexicon.RDFFullTextIndexTupleSerializer;
import com.bigdata.rdf.model.BigdataValue;
import com.bigdata.rdf.store.AbstractTripleStore;
import com.bigdata.search.FullTextIndex;
import com.bigdata.search.Hit;
import com.bigdata.search.TokenBuffer;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.openrdf.model.Literal;

public class BigdataValueCentricFullTextIndex
extends FullTextIndex
implements IValueCentricTextIndexer<Hit> {
    private static final transient Logger log = Logger.getLogger(BigdataValueCentricFullTextIndex.class);
    private final boolean indexDatatypeLiterals = Boolean.parseBoolean(this.getProperty(AbstractTripleStore.Options.TEXT_INDEX_DATATYPE_LITERALS, "true"));
    private LexiconRelation lexiconRelation;

    public static BigdataValueCentricFullTextIndex getInstance(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        if (namespace == null) {
            throw new IllegalArgumentException();
        }
        return new BigdataValueCentricFullTextIndex(indexManager, namespace, timestamp, properties);
    }

    @Override
    public boolean getIndexDatatypeLiterals() {
        return this.indexDatatypeLiterals;
    }

    public BigdataValueCentricFullTextIndex(IIndexManager indexManager, String namespace, Long timestamp, Properties properties) {
        super(indexManager, namespace, timestamp, properties);
    }

    @Override
    public void create() {
        this.assertWritable();
        String name = this.getNamespace() + "." + "search";
        IIndexManager indexManager = this.getIndexManager();
        Properties p = this.getProperties();
        IndexMetadata indexMetadata = new IndexMetadata(indexManager, p, name, UUID.randomUUID(), IndexTypeEnum.BTree);
        Properties tmp = new Properties(p);
        tmp.setProperty(KeyBuilder.Options.STRENGTH, p.getProperty(FullTextIndex.Options.INDEXER_COLLATOR_STRENGTH, FullTextIndex.Options.DEFAULT_INDEXER_COLLATOR_STRENGTH));
        DefaultKeyBuilderFactory keyBuilderFactory = new DefaultKeyBuilderFactory(tmp);
        boolean fieldsEnabled = Boolean.parseBoolean(p.getProperty(FullTextIndex.Options.FIELDS_ENABLED, "false"));
        if (log.isInfoEnabled()) {
            log.info((Object)(FullTextIndex.Options.FIELDS_ENABLED + "=" + fieldsEnabled));
        }
        indexMetadata.setTupleSerializer(new RDFFullTextIndexTupleSerializer(keyBuilderFactory, DefaultTupleSerializer.getDefaultLeafKeysCoder(), SimpleRabaCoder.INSTANCE, fieldsEnabled));
        indexManager.registerIndex(indexMetadata);
        if (log.isInfoEnabled()) {
            log.info((Object)("Registered new text index: name=" + name));
        }
    }

    @Override
    public void destroy() {
        if (log.isInfoEnabled()) {
            log.info((Object)"");
        }
        this.assertWritable();
        String name = this.getNamespace() + "." + "search";
        this.getIndexManager().dropIndex(name);
    }

    @Override
    public void index(int capacity, Iterator<BigdataValue> valuesIterator) {
        TokenBuffer buffer = new TokenBuffer(capacity, this);
        int n = 0;
        while (valuesIterator.hasNext()) {
            BigdataValue val = valuesIterator.next();
            if (!(val instanceof Literal)) continue;
            Literal lit = (Literal)val;
            if (!this.indexDatatypeLiterals && lit.getDatatype() != null) continue;
            String languageCode = lit.getLanguage();
            String text = lit.getLabel();
            IV termId = val.getIV();
            assert (termId != null);
            this.index(buffer, termId, 0, languageCode, new StringReader(text));
            ++n;
        }
        buffer.flush();
        if (log.isInfoEnabled()) {
            log.info((Object)("indexed " + n + " new terms"));
        }
    }

    public final synchronized LexiconRelation getLexiconRelation() {
        if (this.lexiconRelation == null) {
            long t = this.getTimestamp();
            if (TimestampUtility.isReadWriteTx(t)) {
                t = 0L;
            }
            String ns = this.getNamespace();
            if (log.isDebugEnabled()) {
                log.debug((Object)ns);
            }
            this.lexiconRelation = (LexiconRelation)this.getIndexManager().getResourceLocator().locate(ns, t);
        }
        return this.lexiconRelation;
    }

    protected Hit[] matchExact(Hit[] hits, String query) {
        int chunkSize = 1000;
        Hit[] tmp = new Hit[hits.length];
        HashMap<IV, Hit> iv2Hit = new HashMap<IV, Hit>(1000);
        LexiconRelation lex = this.getLexiconRelation();
        int i = 0;
        int k = 0;
        while (i < hits.length) {
            iv2Hit.clear();
            for (int j = 0; j < 1000 && i < hits.length; ++j) {
                Hit h = hits[i++];
                iv2Hit.put((IV)h.getDocId(), h);
            }
            Map<IV<?, ?>, BigdataValue> terms = lex.getTerms(iv2Hit.keySet());
            for (Map.Entry<IV<?, ?>, BigdataValue> e : terms.entrySet()) {
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                IV<?, ?> iv = e.getKey();
                BigdataValue term = e.getValue();
                if (!term.stringValue().contains(query)) continue;
                tmp[k++] = (Hit)iv2Hit.get(iv);
            }
        }
        if (k < hits.length) {
            Hit[] a = new Hit[k];
            System.arraycopy(tmp, 0, a, 0, k);
            return a;
        }
        return hits;
    }

    protected Hit[] applyRegex(Hit[] hits, Pattern regex) {
        int chunkSize = 1000;
        Hit[] tmp = new Hit[hits.length];
        HashMap<IV, Hit> iv2Hit = new HashMap<IV, Hit>(1000);
        LexiconRelation lex = this.getLexiconRelation();
        int i = 0;
        int k = 0;
        while (i < hits.length) {
            iv2Hit.clear();
            for (int j = 0; j < 1000 && i < hits.length; ++j) {
                Hit h = hits[i++];
                iv2Hit.put((IV)h.getDocId(), h);
            }
            Map<IV<?, ?>, BigdataValue> terms = lex.getTerms(iv2Hit.keySet());
            for (Map.Entry<IV<?, ?>, BigdataValue> e : terms.entrySet()) {
                if (Thread.interrupted()) {
                    throw new RuntimeException(new InterruptedException());
                }
                IV<?, ?> iv = e.getKey();
                BigdataValue term = e.getValue();
                String s = term.stringValue();
                Matcher matcher = regex.matcher(s);
                if (!matcher.find()) continue;
                tmp[k++] = (Hit)iv2Hit.get(iv);
            }
        }
        if (k < hits.length) {
            Hit[] a = new Hit[k];
            System.arraycopy(tmp, 0, a, 0, k);
            return a;
        }
        return hits;
    }
}

