/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.load;

import com.bigdata.rdf.ServiceProviderHook;
import java.io.File;
import java.io.FilenameFilter;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.openrdf.rio.RDFFormat;

public class RDFFilenameFilter
implements FilenameFilter,
Serializable {
    protected static final transient Logger log = Logger.getLogger(RDFFilenameFilter.class);
    private static final long serialVersionUID = -628798437502907063L;

    @Override
    public boolean accept(File dir, String name) {
        String s;
        File file = new File(dir, name);
        if (file.isHidden()) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        if (RDFFormat.forFileName((String)name) != null) {
            return true;
        }
        if (name.endsWith(".gz") && RDFFormat.forFileName((String)(s = name.substring(0, name.length() - 3))) != null) {
            return true;
        }
        return name.endsWith(".zip") && RDFFormat.forFileName((String)(s = name.substring(0, name.length() - 4))) != null;
    }

    static {
        ServiceProviderHook.forceLoad();
    }
}

