/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import info.aduna.iteration.CloseableIteration;
import java.util.NoSuchElementException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.sail.SailException;

public class QueryEvaluationIterator<T>
implements CloseableIteration<T, QueryEvaluationException> {
    private final CloseableIteration<? extends T, SailException> src;
    private boolean open = true;

    public QueryEvaluationIterator(CloseableIteration<? extends T, SailException> src) {
        assert (src != null);
        this.src = src;
    }

    public boolean hasNext() throws QueryEvaluationException {
        if (this.open && this._hasNext()) {
            return true;
        }
        this.close();
        return false;
    }

    private boolean _hasNext() throws QueryEvaluationException {
        try {
            return this.src.hasNext();
        }
        catch (SailException ex) {
            throw new QueryEvaluationException((Throwable)ex);
        }
    }

    public T next() throws QueryEvaluationException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        try {
            return (T)this.src.next();
        }
        catch (SailException ex) {
            throw new QueryEvaluationException((Throwable)ex);
        }
    }

    public void remove() throws QueryEvaluationException {
        if (!this.open) {
            throw new IllegalStateException();
        }
        try {
            this.src.remove();
        }
        catch (SailException ex) {
            throw new QueryEvaluationException((Throwable)ex);
        }
    }

    public void close() throws QueryEvaluationException {
        if (this.open) {
            this.open = false;
            try {
                this.src.close();
            }
            catch (SailException ex) {
                throw new QueryEvaluationException((Throwable)ex);
            }
        }
    }
}

