/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail;

import com.bigdata.rdf.sparql.ast.Update;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class SPARQLUpdateEvent {
    private final Update op;
    private final long elapsed;
    private final long connectionFlushNanos;
    private final long batchResolveNanos;
    private DeleteInsertWhereStats deleteInsertWhereStats;
    private final Throwable cause;

    public SPARQLUpdateEvent(Update op, long elapsed, long connectionFlushNanos, long batchResolveNanos, Throwable cause, DeleteInsertWhereStats deleteInsertWhereStats) {
        if (op == null) {
            throw new IllegalArgumentException();
        }
        this.op = op;
        this.elapsed = elapsed;
        this.connectionFlushNanos = connectionFlushNanos;
        this.batchResolveNanos = batchResolveNanos;
        this.deleteInsertWhereStats = deleteInsertWhereStats;
        this.cause = cause;
    }

    public Update getUpdate() {
        return this.op;
    }

    public long getElapsedNanos() {
        return this.elapsed;
    }

    public long getConnectionFlushNanos() {
        return this.connectionFlushNanos;
    }

    public long getBatchResolveNanos() {
        return this.batchResolveNanos;
    }

    public Throwable getCause() {
        return this.cause;
    }

    public DeleteInsertWhereStats getDeleteInsertWhereStats() {
        return this.deleteInsertWhereStats;
    }

    public static class LoadProgress
    extends SPARQLUpdateEvent {
        private final long nparsed;
        private final boolean done;

        public LoadProgress(Update op, long elapsed, long nparsed, boolean done) {
            super(op, elapsed, 0L, 0L, null, null);
            this.nparsed = nparsed;
            this.done = done;
        }

        public long getParsedCount() {
            return this.nparsed;
        }

        public boolean isDone() {
            return this.done;
        }

        public long triplesPerSecond() {
            long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(this.getElapsedNanos());
            if (elapsedMillis == 0L) {
                elapsedMillis = 1L;
            }
            return (long)((double)this.nparsed / (double)elapsedMillis * 1000.0);
        }
    }

    public static class DeleteInsertWhereStats {
        public final AtomicLong whereNanos = new AtomicLong();
        public final AtomicLong deleteNanos = new AtomicLong();
        public final AtomicLong insertNanos = new AtomicLong();
    }
}

