/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp;

import com.bigdata.Banner;
import com.bigdata.BigdataStatics;
import com.bigdata.bop.BOpUtility;
import com.bigdata.bop.PipelineOp;
import com.bigdata.bop.engine.AbstractRunningQuery;
import com.bigdata.bop.engine.BOpStats;
import com.bigdata.bop.engine.IRunningQuery;
import com.bigdata.bop.engine.QueryEngine;
import com.bigdata.bop.engine.QueryLog;
import com.bigdata.bop.fed.QueryEngineFactory;
import com.bigdata.counters.CounterSet;
import com.bigdata.ha.HAGlue;
import com.bigdata.ha.QuorumService;
import com.bigdata.journal.AbstractJournal;
import com.bigdata.journal.DumpJournal;
import com.bigdata.journal.IIndexManager;
import com.bigdata.journal.Journal;
import com.bigdata.quorum.Quorum;
import com.bigdata.rdf.sail.QueryCancellationHelper;
import com.bigdata.rdf.sail.model.JsonHelper;
import com.bigdata.rdf.sail.model.RunningQuery;
import com.bigdata.rdf.sail.sparql.ast.SimpleNode;
import com.bigdata.rdf.sail.webapp.BigdataRDFContext;
import com.bigdata.rdf.sail.webapp.BigdataRDFServlet;
import com.bigdata.rdf.sail.webapp.ConnegUtil;
import com.bigdata.rdf.sail.webapp.HAStatusServletUtilProxy;
import com.bigdata.rdf.sail.webapp.HTMLBuilder;
import com.bigdata.rdf.sail.webapp.IServletDelegate;
import com.bigdata.rdf.sail.webapp.QueryServlet;
import com.bigdata.rdf.sail.webapp.ServletDelegateBase;
import com.bigdata.rdf.sail.webapp.XMLBuilder;
import com.bigdata.rdf.sparql.ast.ASTContainer;
import com.bigdata.rdf.sparql.ast.QueryRoot;
import com.bigdata.rdf.sparql.ast.UpdateRoot;
import com.bigdata.util.ClassPathUtil;
import com.bigdata.util.InnerCause;
import com.bigdata.util.NV;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class StatusServlet
extends BigdataRDFServlet {
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(StatusServlet.class);
    private static final String SHOW_NAMESPACES = "showNamespaces";
    private static final String DUMP_JOURNAL = "dumpJournal";
    private static final String DUMP_PAGES = "dumpPages";
    private static final String DUMP_NAMESPACE = "dumpNamespace";
    private static final String SHOW_QUERIES = "showQueries";
    private static final String DETAILS = "details";
    private static final String QUERY_ID = "queryId";
    protected static final String CANCEL_QUERY = "cancelQuery";
    static final String SNAPSHOT = "snapshot";
    static final String DIGESTS = "digests";
    static final DigestEnum DEFAULT_DIGESTS = DigestEnum.Journal;
    static final String THREAD_DUMP = "threadDump";
    static final String HA = "HA";
    static final String HEALTH = "health";
    static final String MAPGRAPH = "mapgraph";

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean cancelQuery;
        boolean bl = cancelQuery = req.getParameter(CANCEL_QUERY) != null;
        if (cancelQuery) {
            StatusServlet.doCancelQuery(req, resp, this.getIndexManager(), this.getBigdataRDFContext());
        }
        this.doGet(req, resp);
    }

    static void doCancelQuery(HttpServletRequest req, HttpServletResponse resp, IIndexManager indexManager, BigdataRDFContext context) throws IOException {
        String[] a = req.getParameterValues(QUERY_ID);
        if (a == null || a.length == 0) {
            StatusServlet.buildAndCommitResponse(resp, 400, "text/plain", "Required parameter not found: queryId", new NV[0]);
            return;
        }
        LinkedHashSet<UUID> queryIds = new LinkedHashSet<UUID>();
        for (String s : a) {
            queryIds.add(UUID.fromString(s));
        }
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(indexManager);
        for (UUID queryId : queryIds) {
            if (QueryCancellationHelper.tryCancelQuery(queryEngine, queryId) || StatusServlet.tryCancelUpdate(context, queryId) || StatusServlet.tryCancelTask(context, queryId)) continue;
            queryEngine.addPendingCancel(queryId);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)("No such QUERY, UPDATE, or task: " + queryId));
        }
    }

    private static boolean tryCancelUpdate(BigdataRDFContext context, UUID queryId) {
        Future f;
        BigdataRDFContext.RunningQuery query = context.getQueryById(queryId);
        return query != null && query.queryTask instanceof BigdataRDFContext.UpdateTask && (f = ((BigdataRDFContext.UpdateTask)query.queryTask).updateFuture) != null && f.cancel(true);
    }

    private static boolean tryCancelTask(BigdataRDFContext context, UUID queryId) {
        FutureTask f;
        BigdataRDFContext.TaskAndFutureTask<?> tmp = context.getTaskById(queryId);
        return tmp != null && (f = tmp.ft) != null && f.cancel(true);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (req.getParameter(THREAD_DUMP) != null) {
            StatusServlet.doThreadDump(req, resp);
            return;
        }
        if (req.getParameter(HA) != null && this.getIndexManager() instanceof AbstractJournal && ((AbstractJournal)this.getIndexManager()).getQuorum() != null) {
            new HAStatusServletUtilProxy.HAStatusServletUtilFactory().getInstance(this.getIndexManager()).doHAStatus(req, resp);
            return;
        }
        if (req.getParameter(HEALTH) != null) {
            new HAStatusServletUtilProxy.HAStatusServletUtilFactory().getInstance(this.getIndexManager()).doHealthStatus(req, resp);
            return;
        }
        if (req.getParameter(MAPGRAPH) != null) {
            IServletDelegate delegate = (IServletDelegate)ClassPathUtil.classForName((String)"com.blazegraph.gpu.webapp.MapgraphStatusServletDelegate", ServletDelegateBase.class, IServletDelegate.class, (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
            delegate.doGet(req, resp);
            return;
        }
        String acceptHeader = ConnegUtil.getMimeTypeForQueryParameterServiceRequest(req.getParameter("format"), req.getHeader("Accept"));
        if ("application/json".equals(acceptHeader)) {
            this.doGetJsonResponse(req, resp);
        } else {
            this.doGetHtmlResponse(req, resp);
        }
    }

    private void doGetJsonResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
        Set<UUID> requestedQueryIds = this.getRequestedQueryIds(req);
        Map<UUID, BigdataRDFContext.RunningQuery> crosswalkMap = this.getQueryCrosswalkMap();
        ArrayList<RunningQuery> modelRunningQueries = new ArrayList<RunningQuery>();
        QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(this.getIndexManager());
        UUID[] queryIds = queryEngine.getRunningQueries();
        TreeMap<Long, IRunningQuery> runningQueryAge = this.orderRunningQueries(queryIds, crosswalkMap, queryEngine);
        for (BigdataRDFContext.RunningQuery r : this.getRunningSparqlQueries(requestedQueryIds, runningQueryAge, crosswalkMap)) {
            modelRunningQueries.add(r.getModelRunningQuery());
        }
        for (BigdataRDFContext.RunningQuery r : this.getPendingUpdates(requestedQueryIds)) {
            modelRunningQueries.add(r.getModelRunningQuery());
        }
        JsonHelper.writeRunningQueryList((Writer)w, modelRunningQueries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGetHtmlResponse(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean showQueries = req.getParameter(SHOW_QUERIES) != null;
        boolean showQueryDetails = false;
        if (showQueries) {
            for (String tmp : req.getParameterValues(SHOW_QUERIES)) {
                if (!tmp.equals(DETAILS)) continue;
                showQueryDetails = true;
            }
        }
        int maxBopLength = 0;
        if (req.getParameter("maxBopLength") != null && (maxBopLength = Integer.valueOf(req.getParameter("maxBopLength")).intValue()) < 0) {
            maxBopLength = 0;
        }
        boolean showNamespaces = req.getParameter(SHOW_NAMESPACES) != null;
        resp.setContentType("text/html");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)resp.getOutputStream(), "UTF-8");
        try {
            String buildVer;
            Quorum<HAGlue, QuorumService<HAGlue>> quorum;
            boolean dumpJournal;
            HTMLBuilder doc = new HTMLBuilder("UTF-8", w);
            XMLBuilder.Node current = doc.root("html");
            BigdataRDFContext.addHtmlHeader(current, "UTF-8");
            boolean bl = dumpJournal = req.getParameter(DUMP_JOURNAL) != null;
            if (dumpJournal && this.getIndexManager() instanceof AbstractJournal) {
                List<String> namespaces;
                current.node("h1", "Dump Journal").node("p", "Running...");
                doc.getWriter().flush();
                PrintWriter out = new PrintWriter((OutputStream)resp.getOutputStream(), true);
                out.print("<pre id=\"journal-dump\">\n");
                DumpJournal dump = new DumpJournal((Journal)this.getIndexManager());
                String[] a = req.getParameterValues(DUMP_NAMESPACE);
                if (a == null) {
                    namespaces = Collections.emptyList();
                } else {
                    namespaces = new LinkedList();
                    for (String namespace : a) {
                        namespaces.add(namespace);
                    }
                }
                boolean dumpHistory = false;
                boolean dumpPages = req.getParameter(DUMP_PAGES) != null;
                boolean dumpIndices = false;
                boolean dumpTuples = false;
                dump.dumpJournal(out, namespaces, false, dumpPages, false, false);
                out.print("\n</pre>");
                out.flush();
            }
            if (this.getIndexManager() instanceof AbstractJournal && (quorum = ((AbstractJournal)this.getIndexManager()).getQuorum()) != null) {
                new HAStatusServletUtilProxy.HAStatusServletUtilFactory().getInstance(this.getIndexManager()).doGet(req, resp, current);
            }
            if ((buildVer = (String)Banner.getBuildInfo().get("buildVersion")) == null) {
                buildVer = "N/A";
            }
            current.node("p").text("Build Version=").node("span").attr("id", "buildVersion").text(buildVer).close().close();
            String gitCommit = (String)Banner.getBuildInfo().get("gitCommit");
            if (gitCommit == null || "${git.commit}".equals(gitCommit)) {
                gitCommit = "N/A";
            }
            current.node("p").text("Build Git Commit=").node("span").attr("id", "gitCommit").text(gitCommit).close().close();
            String gitBranch = (String)Banner.getBuildInfo().get("gitBranch");
            if (gitBranch == null || "${git.branch}".equals(gitBranch)) {
                gitBranch = "N/A";
            }
            current.node("p").text("Build Git Branch=").node("span").attr("id", "gitBranch").text(gitBranch).close().close();
            current.node("p").text("Accepted query count=").node("span").attr("id", "accepted-query-count").text("" + this.getBigdataRDFContext().getQueryIdFactory().get()).close().close();
            current.node("p").text("Running query count=").node("span").attr("id", "running-query-count").text("" + this.getBigdataRDFContext().getQueries().size()).close().close();
            String showQueriesURL = req.getRequestURL().append("?").append(SHOW_QUERIES).toString();
            String showQueriesDetailsURL = req.getRequestURL().append("?").append(SHOW_QUERIES).append("=").append(DETAILS).toString();
            current.node("p").text("Show ").node("a").attr("href", showQueriesURL).attr("id", "show-queries").text("queries").close().text(", ").node("a").attr("href", showQueriesDetailsURL).attr("id", "show-query-details").text("query details").close().text(".").close();
            if (showNamespaces) {
                List<String> namespaces = this.getBigdataRDFContext().getNamespaces(this.getTimestamp(req));
                current.node("h3", "Namespaces: ");
                XMLBuilder.Node ul = current.node("ul").attr("id", "namespaces");
                for (String s : namespaces) {
                    ul.node("li", s);
                }
                ul.close();
            }
            QueryEngine queryEngine = QueryEngineFactory.getInstance().getQueryController(this.getIndexManager());
            CounterSet counterSet = queryEngine.getCounters();
            if (this.getBigdataRDFContext().getSampleTask() != null) {
                counterSet.makePath("queryService").attach(this.getBigdataRDFContext().getSampleTask().getCounters());
            }
            current.node("p").attr("id", "counter-set").text(counterSet.toString()).close();
            if (!showQueries) {
                doc.closeAll(current);
                return;
            }
            Set<UUID> requestedQueryIds = this.getRequestedQueryIds(req);
            Map<UUID, BigdataRDFContext.RunningQuery> crosswalkMap = this.getQueryCrosswalkMap();
            QueryEngine queryEngine2 = QueryEngineFactory.getInstance().getQueryController(this.getIndexManager());
            UUID[] queryIds = queryEngine2.getRunningQueries();
            TreeMap<Long, IRunningQuery> runningQueryAge = this.orderRunningQueries(queryIds, crosswalkMap, queryEngine2);
            for (BigdataRDFContext.RunningQuery acceptedQuery : this.getRunningSparqlQueries(requestedQueryIds, runningQueryAge, crosswalkMap)) {
                current = this.showQuery(req, resp, w, current, queryEngine2.getRunningQuery(acceptedQuery.queryId2), acceptedQuery, showQueryDetails, maxBopLength);
            }
            for (BigdataRDFContext.RunningQuery acceptedQuery : this.getPendingUpdates(requestedQueryIds)) {
                this.showUpdateRequest(req, resp, current, acceptedQuery, showQueryDetails);
            }
            for (BigdataRDFContext.TaskAndFutureTask<?> task : this.getOtherTasks(requestedQueryIds)) {
                this.showTaskRequest(req, resp, current, task, showQueryDetails);
            }
            doc.closeAll(current);
        }
        catch (Throwable t) {
            log.error((Object)t, t);
        }
        finally {
            ((Writer)w).flush();
            ((Writer)w).close();
        }
    }

    private XMLBuilder.Node showUpdateRequest(HttpServletRequest req, HttpServletResponse resp, XMLBuilder.Node current, BigdataRDFContext.RunningQuery acceptedQuery, boolean showQueryDetails) throws IOException {
        UUID queryId = acceptedQuery.queryId2;
        BigdataRDFContext.UpdateTask updateTask = (BigdataRDFContext.UpdateTask)acceptedQuery.queryTask;
        long elapsedMillis = updateTask.getElapsedExecutionMillis();
        long mutationCount = updateTask.getMutationCount();
        current.node("h1", "Update");
        current = current.node("FORM").attr("method", "POST").attr("action", "");
        String detailsURL = req.getRequestURL().append("?").append(SHOW_QUERIES).append("=").append(DETAILS).append("&").append(QUERY_ID).append("=").append(queryId.toString()).toString();
        current.node("p").attr("class", "update").text("elapsed=").node("span").attr("class", "elapsed").text("" + elapsedMillis).close().text("ms").text(", ").text("mutationCount=").node("span").attr("class", "mutationCount").text("" + mutationCount).close().text(", ").node("a").attr("href", detailsURL).attr("class", "details-url").text(DETAILS).close().close();
        current = current.node("p");
        current.node("INPUT").attr("type", "hidden").attr("name", QUERY_ID).attr("value", queryId).close();
        current.node("INPUT").attr("type", "submit").attr("name", CANCEL_QUERY).attr("value", "Cancel").close();
        current = current.close();
        current = current.close();
        ASTContainer astContainer = acceptedQuery.queryTask.astContainer;
        String queryString = astContainer.getQueryString();
        if (queryString != null) {
            current.node("h2", "SPARQL");
            current.node("p").attr("class", "query-string").text(queryString).close();
        }
        if (showQueryDetails) {
            UpdateRoot originalAST;
            SimpleNode parseTree = (SimpleNode)astContainer.getParseTree();
            if (parseTree != null) {
                current.node("h2", "Parse Tree");
                current.node("p").attr("class", "parse-tree").text(parseTree.dump("")).close();
            }
            if ((originalAST = astContainer.getOriginalUpdateAST()) != null) {
                current.node("h2", "Original AST");
                current.node("p").attr("class", "original-ast").text(originalAST.toString()).close();
            }
        }
        return current;
    }

    private <T> XMLBuilder.Node showTaskRequest(HttpServletRequest req, HttpServletResponse resp, XMLBuilder.Node current, BigdataRDFContext.TaskAndFutureTask<T> task, boolean showQueryDetails) throws IOException {
        UUID queryId = task.task.uuid;
        long elapsedMillis = TimeUnit.NANOSECONDS.toMillis(task.getElapsedNanos());
        current.node("h1", "Task");
        current = current.node("FORM").attr("method", "POST").attr("action", "");
        String detailsURL = req.getRequestURL().append("?").append(SHOW_QUERIES).append("=").append(DETAILS).append("&").append(QUERY_ID).append("=").append(queryId.toString()).toString();
        current.node("p").attr("class", "task").text("elapsed=").node("span").attr("class", "elapsed").text("" + elapsedMillis).close().text("ms").text(", ").node("a").attr("href", detailsURL).attr("class", "details-url").text(DETAILS).close().close();
        current = current.node("p");
        current.node("INPUT").attr("type", "hidden").attr("name", QUERY_ID).attr("value", queryId).close();
        current.node("INPUT").attr("type", "submit").attr("name", CANCEL_QUERY).attr("value", "Cancel").close();
        current = current.close();
        current = current.close();
        String queryString = task.task.toString();
        if (queryString != null) {
            current.node("h2", "TASK");
            current.node("p").attr("class", "query-string").text(task.task.toString()).close();
        }
        return current;
    }

    private XMLBuilder.Node showQuery(HttpServletRequest req, HttpServletResponse resp, Writer w, XMLBuilder.Node current, IRunningQuery q, BigdataRDFContext.RunningQuery acceptedQuery, boolean showQueryDetails, int maxBopLength) throws IOException {
        String queryString;
        UUID queryId = q.getQueryId();
        IRunningQuery[] children = ((AbstractRunningQuery)q).getChildren();
        long elapsedMillis = q.getElapsed();
        current.node("h1", "Query");
        current = current.node("FORM").attr("method", "POST").attr("action", "");
        String detailsURL = req.getRequestURL().append("?").append(SHOW_QUERIES).append("=").append(DETAILS).append("&").append(QUERY_ID).append("=").append(queryId.toString()).toString();
        BOpStats stats = q.getStats().get(q.getQuery().getId());
        String solutionsOut = stats == null ? "N/A" : Long.toString(stats.unitsOut.get());
        String chunksOut = stats == null ? "N/A" : Long.toString(stats.chunksOut.get());
        current.node("p").text("solutions=").node("span").attr("class", "solutions").text("" + solutionsOut).close().text(", chunks=").node("span").attr("class", "chunks").text("" + chunksOut).close().text(", children=").node("span").attr("class", "children").text("" + children.length).close().text(", elapsed=").node("span").attr("class", "elapsed").text("" + elapsedMillis).close().text("ms, ").node("a").attr("href", detailsURL).attr("class", "details-url").text(DETAILS).close().close();
        current = current.node("p");
        current.node("INPUT").attr("type", "hidden").attr("name", QUERY_ID).attr("value", queryId).close();
        current.node("INPUT").attr("type", "submit").attr("name", CANCEL_QUERY).attr("value", "Cancel").close();
        current = current.close();
        current = current.close();
        if (acceptedQuery != null) {
            ASTContainer astContainer = acceptedQuery.queryTask.astContainer;
            queryString = astContainer.getQueryString();
            if (queryString != null) {
                current.node("h2", "SPARQL");
                current.node("p").attr("class", "query-string").text(queryString).close();
            }
            if (showQueryDetails) {
                PipelineOp queryPlan;
                QueryRoot optimizedAST;
                QueryRoot originalAST;
                SimpleNode parseTree = (SimpleNode)astContainer.getParseTree();
                if (parseTree != null) {
                    current.node("h2", "Parse Tree");
                    current.node("p").attr("class", "parse-tree").text(parseTree.dump("")).close();
                }
                if ((originalAST = astContainer.getOriginalAST()) != null) {
                    current.node("h2", "Original AST");
                    current.node("p").attr("class", "original-ast").text(originalAST.toString()).close();
                }
                if ((optimizedAST = astContainer.getOptimizedAST()) != null) {
                    current.node("h2", "Optimized AST");
                    current.node("p").attr("class", "optimized-ast").text(optimizedAST.toString()).close();
                }
                if ((queryPlan = astContainer.getQueryPlan()) != null) {
                    current.node("h2", "Query Plan");
                    current.node("p").attr("class", "query-plan").text(BOpUtility.toString(queryPlan)).close();
                }
            }
        } else {
            queryString = "N/A";
        }
        if (showQueryDetails) {
            current.node("h2", "Query Evaluation Statistics");
            boolean clusterStats = q.getFederation() != null;
            boolean detailedStats = false;
            boolean mutationStats = false;
            QueryLog.getTableXHTML(queryString, q, children, w, !showQueryDetails, maxBopLength, clusterStats, false, false);
        }
        return current;
    }

    private <T> TreeMap<Long, T> newQueryMap() {
        return new TreeMap(new Comparator<Long>(){

            @Override
            public int compare(Long o1, Long o2) {
                if (o1 < o2) {
                    return 1;
                }
                if (o1 > o2) {
                    return -1;
                }
                return 0;
            }
        });
    }

    private Map<UUID, BigdataRDFContext.RunningQuery> getQueryCrosswalkMap() {
        LinkedHashMap<UUID, BigdataRDFContext.RunningQuery> crosswalkMap = new LinkedHashMap<UUID, BigdataRDFContext.RunningQuery>();
        for (BigdataRDFContext.RunningQuery query : this.getBigdataRDFContext().getQueries().values()) {
            crosswalkMap.put(query.queryId2, query);
        }
        return crosswalkMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doThreadDump(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setStatus(200);
        resp.addHeader("Cache-Control", "no-cache");
        resp.setContentType("text/plain");
        try (PrintWriter w = resp.getWriter();){
            BigdataStatics.threadDump((Appendable)w);
            w.flush();
        }
    }

    private Set<UUID> getRequestedQueryIds(HttpServletRequest req) {
        HashSet<UUID> requestedQueryIds = new HashSet<UUID>();
        String[] a = req.getParameterValues(QUERY_ID);
        if (a != null && a.length > 0) {
            for (String s : a) {
                UUID queryId = UUID.fromString(s);
                requestedQueryIds.add(queryId);
            }
        }
        return requestedQueryIds;
    }

    private TreeMap<Long, IRunningQuery> orderRunningQueries(UUID[] queryIds, Map<UUID, BigdataRDFContext.RunningQuery> crosswalkMap, QueryEngine queryEngine) {
        TreeMap<Long, IRunningQuery> runningQueryAge = this.newQueryMap();
        for (UUID queryId : queryIds) {
            AbstractRunningQuery query;
            try {
                query = queryEngine.getRunningQuery(queryId);
                if (query == null) {
                    continue;
                }
            }
            catch (RuntimeException e) {
                if (InnerCause.isInnerCause((Throwable)e, InterruptedException.class)) continue;
                throw new RuntimeException(e);
            }
            Long elapsedTime = new Long(query.getElapsed());
            runningQueryAge.put(elapsedTime, query);
        }
        return runningQueryAge;
    }

    private Collection<BigdataRDFContext.RunningQuery> getRunningSparqlQueries(Set<UUID> requestedQueryIds, TreeMap<Long, IRunningQuery> runningQueryAge, Map<UUID, BigdataRDFContext.RunningQuery> crosswalkMap) {
        Iterator<Map.Entry<Long, IRunningQuery>> itr = runningQueryAge.entrySet().iterator();
        LinkedList<BigdataRDFContext.RunningQuery> runningSparqlQueries = new LinkedList<BigdataRDFContext.RunningQuery>();
        while (itr.hasNext()) {
            BigdataRDFContext.RunningQuery acceptedQuery;
            Map.Entry<Long, IRunningQuery> e = itr.next();
            IRunningQuery q = e.getValue();
            if (q.isDone() && q.getCause() != null) continue;
            UUID queryId = q.getQueryId();
            if (!requestedQueryIds.isEmpty() && !requestedQueryIds.contains(queryId) || (acceptedQuery = crosswalkMap.get(queryId)) == null) continue;
            runningSparqlQueries.add(acceptedQuery);
        }
        return runningSparqlQueries;
    }

    private Collection<BigdataRDFContext.RunningQuery> getPendingUpdates(Set<UUID> requestedQueryIds) {
        LinkedList<BigdataRDFContext.RunningQuery> pendingUpdates = new LinkedList<BigdataRDFContext.RunningQuery>();
        for (BigdataRDFContext.RunningQuery acceptedQuery : this.getBigdataRDFContext().getQueries().values()) {
            UUID queryId;
            if (!(acceptedQuery.queryTask instanceof BigdataRDFContext.UpdateTask) || (queryId = acceptedQuery.queryId2) == null || !requestedQueryIds.isEmpty() && !requestedQueryIds.contains(queryId) || acceptedQuery.queryTask.updateFuture == null) continue;
            Future<Void> f = acceptedQuery.queryTask.updateFuture;
            if (f.isDone()) {
                try {
                    f.get();
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    continue;
                }
            }
            pendingUpdates.add(acceptedQuery);
        }
        return pendingUpdates;
    }

    private Collection<BigdataRDFContext.TaskAndFutureTask<?>> getOtherTasks(Set<UUID> requestedQueryIds) {
        LinkedList otherTasks = new LinkedList();
        for (BigdataRDFContext.TaskAndFutureTask<?> task : this.getBigdataRDFContext().getTasks().values()) {
            if (task.task instanceof QueryServlet.SparqlUpdateTask || task.task instanceof QueryServlet.SparqlQueryTask) continue;
            UUID queryId = task.task.uuid;
            if (!requestedQueryIds.isEmpty() && !requestedQueryIds.contains(queryId)) continue;
            FutureTask f = task.ft;
            if (f != null && f.isDone()) {
                try {
                    f.get();
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException ex) {
                    continue;
                }
            }
            otherTasks.add(task);
        }
        return otherTasks;
    }

    static enum DigestEnum {
        None,
        Journal,
        HALogs,
        Snapshots,
        All;

    }
}

