/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast;

import com.bigdata.bop.IVariable;
import com.bigdata.rdf.sparql.ast.IBindingProducerNode;
import com.bigdata.rdf.sparql.ast.IGroupMemberNode;
import com.bigdata.rdf.sparql.ast.StaticAnalysis;
import com.bigdata.rdf.sparql.ast.SubqueryRoot;
import com.bigdata.rdf.sparql.ast.optimizers.ASTJoinGroupFilterExistsInfo;
import java.util.HashSet;
import java.util.Set;

public class GroupNodeVarBindingInfo {
    private final IGroupMemberNode node;
    private final Set<IVariable<?>> requiredBound;
    private final Set<IVariable<?>> desiredBound;
    private final Set<IVariable<?>> maybeProduced;
    private final Set<IVariable<?>> definitelyProduced;

    public GroupNodeVarBindingInfo(IGroupMemberNode node, StaticAnalysis sa, ASTJoinGroupFilterExistsInfo fExInfo) {
        this.node = node;
        this.requiredBound = node.getRequiredBound(sa);
        this.desiredBound = node.getDesiredBound(sa);
        this.maybeProduced = new HashSet();
        if (node instanceof IBindingProducerNode) {
            sa.getMaybeProducedBindings((IBindingProducerNode)((Object)node), this.maybeProduced, true);
        }
        this.definitelyProduced = new HashSet();
        if (node instanceof IBindingProducerNode && !StaticAnalysis.isMinusOrOptional(node)) {
            sa.getDefinitelyProducedBindings((IBindingProducerNode)((Object)node), this.definitelyProduced, true);
        }
        if (fExInfo != null && node instanceof SubqueryRoot && fExInfo.containsSubqueryRoot((SubqueryRoot)node)) {
            SubqueryRoot sqr = (SubqueryRoot)node;
            this.desiredBound.clear();
            this.definitelyProduced.add(sqr.getAskVar());
            sqr.getProjectedVars(this.requiredBound);
            this.requiredBound.remove(sqr.getAskVar());
        }
    }

    public IGroupMemberNode getNode() {
        return this.node;
    }

    public Set<IVariable<?>> getRequiredBound() {
        return this.requiredBound;
    }

    public Set<IVariable<?>> getDesiredBound() {
        return this.desiredBound;
    }

    public Set<IVariable<?>> getMaybeProduced() {
        return this.maybeProduced;
    }

    public Set<IVariable<?>> getDefinitelyProduced() {
        return this.definitelyProduced;
    }

    public Set<IVariable<?>> leftToBeBound(Set<IVariable<?>> knownBound) {
        HashSet toBeBound = new HashSet();
        toBeBound.addAll(this.requiredBound);
        toBeBound.removeAll(knownBound);
        return toBeBound;
    }
}

