/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sparql.ast.eval;

import com.bigdata.bop.BOp;
import com.bigdata.bop.Constant;
import com.bigdata.bop.IPredicate;
import com.bigdata.bop.IVariable;
import com.bigdata.bop.ap.Predicate;
import com.bigdata.btree.IIndex;
import com.bigdata.counters.CAT;
import com.bigdata.rdf.internal.IV;
import com.bigdata.rdf.spo.ISPO;
import com.bigdata.rdf.spo.SPOAccessPath;
import com.bigdata.relation.accesspath.BlockingBuffer;
import com.bigdata.relation.accesspath.IAccessPath;
import com.bigdata.relation.rule.IAccessPathExpander;
import com.bigdata.striterator.ChunkedWrappedIterator;
import com.bigdata.striterator.IChunkedOrderedIterator;
import com.bigdata.striterator.IKeyOrder;
import com.bigdata.util.concurrent.LatchedExecutor;
import cutthecrap.utils.striterators.ICloseableIterator;
import cutthecrap.utils.striterators.IFilter;
import cutthecrap.utils.striterators.Striterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.apache.log4j.Logger;

public class DGExpander
implements IAccessPathExpander<ISPO> {
    protected static final Logger log = Logger.getLogger(DGExpander.class);
    private static final long serialVersionUID = 1L;
    private final int maxParallel;
    private final Collection<IV> graphs;
    private final long estimatedRangeCount;

    public DGExpander(int maxParallel, Collection<IV> graphs, long estimatedRangeCount) {
        this.maxParallel = maxParallel;
        this.graphs = graphs;
        this.estimatedRangeCount = estimatedRangeCount;
    }

    @Override
    public boolean backchain() {
        return false;
    }

    @Override
    public boolean runFirst() {
        return false;
    }

    @Override
    public IAccessPath<ISPO> getAccessPath(IAccessPath<ISPO> accessPath) {
        return new DefaultGraphParallelEvaluationAccessPath((SPOAccessPath)accessPath);
    }

    public String toString() {
        return super.toString() + "{maxParallel=" + this.maxParallel + ",ngraphs=" + this.graphs.size() + ", estimatedRangeCount=" + this.estimatedRangeCount + ", graphs=" + this.graphs + "}";
    }

    private final class DefaultGraphParallelEvaluationAccessPath
    implements IAccessPath<ISPO> {
        private final SPOAccessPath sourceAccessPath;
        private final Executor executor;

        public String toString() {
            return super.toString() + "{baseAccessPath=" + this.sourceAccessPath.toString() + "}";
        }

        public DefaultGraphParallelEvaluationAccessPath(SPOAccessPath accessPath) {
            this.sourceAccessPath = accessPath;
            this.executor = new LatchedExecutor(accessPath.getIndexManager().getExecutorService(), DGExpander.this.maxParallel);
        }

        @Override
        public IIndex getIndex() {
            return this.sourceAccessPath.getIndex();
        }

        @Override
        public IKeyOrder<ISPO> getKeyOrder() {
            return this.sourceAccessPath.getKeyOrder();
        }

        @Override
        public IPredicate<ISPO> getPredicate() {
            return this.sourceAccessPath.getPredicate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            try (IChunkedOrderedIterator<ISPO> itr = this.iterator(0L, 1L, 1);){
                boolean bl = !itr.hasNext();
                return bl;
            }
        }

        @Override
        public long removeAll() {
            throw new UnsupportedOperationException();
        }

        @Override
        public IChunkedOrderedIterator<ISPO> iterator() {
            return this.iterator(0L, 0L, 0);
        }

        @Override
        public IChunkedOrderedIterator<ISPO> iterator(long offset, long limit, int capacity) {
            InnerIterator1 src = new InnerIterator1(offset, limit, capacity);
            return new ChunkedWrappedIterator<ISPO>((Iterator<ISPO>)((Object)src));
        }

        @Override
        public long rangeCount(boolean exactIsIgnored) {
            return DGExpander.this.estimatedRangeCount;
        }

        private class InnerIterator1
        implements ICloseableIterator<ISPO> {
            private final CAT nAPsWithHits = new CAT();
            private final CAT nhits = new CAT();
            private final BlockingBuffer<ISPO> buffer;
            private final ICloseableIterator<ISPO> src;

            public InnerIterator1(long offset, long limit, int capacity) {
                this.buffer = new BlockingBuffer(DefaultGraphParallelEvaluationAccessPath.this.sourceAccessPath.getChunkCapacity());
                FutureTask<Void> future = null;
                try {
                    future = new FutureTask<Void>(this.newRunIteratorsTask(this.buffer));
                    this.buffer.setFuture(future);
                    DefaultGraphParallelEvaluationAccessPath.this.sourceAccessPath.getIndexManager().getExecutorService().submit(future);
                    IFilter filter = DefaultGraphParallelEvaluationAccessPath.this.sourceAccessPath.getPredicate().getAccessPathFilter();
                    this.src = filter != null ? new ChunkedWrappedIterator<ISPO>((Iterator<ISPO>)new Striterator(this.buffer.iterator()).addFilter(filter)) : this.buffer.iterator();
                }
                catch (Throwable ex) {
                    try {
                        this.buffer.close();
                        if (future != null) {
                            future.cancel(true);
                        }
                    }
                    catch (Throwable t) {
                        log.error((Object)t, t);
                    }
                    throw new RuntimeException(ex);
                }
            }

            public void close() {
                this.src.close();
            }

            public boolean hasNext() {
                if (!this.src.hasNext()) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("#graphs=" + DGExpander.this.graphs.size() + ", nhits=" + this.nhits + ", apsWithHints=" + this.nAPsWithHits + ", pred=" + DefaultGraphParallelEvaluationAccessPath.this.getPredicate()));
                    }
                    return false;
                }
                return true;
            }

            public ISPO next() {
                return (ISPO)this.src.next();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private Callable<Void> newRunIteratorsTask(BlockingBuffer<ISPO> buffer) {
                return new RunIteratorsTask(buffer);
            }

            private final class DrainIteratorTask
            implements Callable<Void> {
                final IV<?, ?> termId;

                public DrainIteratorTask(IV<?, ?> termId) {
                    if (termId == null) {
                        throw new IllegalArgumentException();
                    }
                    this.termId = termId;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Running iterator: c=" + this.termId));
                    }
                    BOp sourcePred = DefaultGraphParallelEvaluationAccessPath.this.sourceAccessPath.getPredicate().clearAnnotations(new String[]{IPredicate.Annotations.ACCESS_PATH_EXPANDER, IPredicate.Annotations.ACCESS_PATH_FILTER});
                    Predicate asBound = sourcePred.asBound((IVariable)sourcePred.get(3), new Constant(this.termId));
                    IAccessPath asBoundAP = DefaultGraphParallelEvaluationAccessPath.this.sourceAccessPath.getRelation().getAccessPath(asBound);
                    try (IChunkedOrderedIterator itr = asBoundAP.iterator();){
                        long n = 0L;
                        while (itr.hasNext()) {
                            ISPO spo = (ISPO)itr.next();
                            InnerIterator1.this.buffer.add(spo);
                            ++n;
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Ran iterator: c=" + this.termId + ", nvisited=" + n));
                        }
                        if (n > 0L) {
                            InnerIterator1.this.nhits.add(n);
                            InnerIterator1.this.nAPsWithHits.increment();
                        }
                    }
                    return null;
                }
            }

            private final class RunIteratorsTask
            implements Callable<Void> {
                private final BlockingBuffer<ISPO> buffer;

                public RunIteratorsTask(BlockingBuffer<ISPO> buffer) {
                    this.buffer = buffer;
                }

                @Override
                public Void call() throws Exception {
                    LinkedList<FutureTask<Void>> tasks = new LinkedList<FutureTask<Void>>();
                    try {
                        for (IV iV : DGExpander.this.graphs) {
                            FutureTask<Void> futureTask = new FutureTask<Void>(new DrainIteratorTask(iV));
                            tasks.add(futureTask);
                            DefaultGraphParallelEvaluationAccessPath.this.executor.execute(futureTask);
                        }
                        for (Future future : tasks) {
                            future.get();
                        }
                    }
                    catch (Throwable ex) {
                        for (Future future : tasks) {
                            future.cancel(true);
                        }
                        throw new RuntimeException(ex);
                    }
                    finally {
                        this.buffer.close();
                    }
                    return null;
                }
            }
        }
    }
}

